/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.item.enchantment;

import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.item.enchantment.WSEnchantment;
import com.degoos.wetsponge.text.translation.WSTranslation;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.enchantment.EnchantmentTypes;

public class SpongeEnchantment
implements WSEnchantment {
    private EnchantmentType enchantment;

    public SpongeEnchantment(EnchantmentType enchantment) {
        this.enchantment = enchantment;
    }

    public SpongeEnchantment(String spongeId) {
        this.enchantment = Sponge.getRegistry().getType(EnchantmentType.class, spongeId).orElse(EnchantmentTypes.PROTECTION);
    }

    @Override
    public WSTranslation getTranslation() {
        throw new IllegalAccessError("Not supported by Spigot");
    }

    @Override
    public String getName() {
        return this.enchantment.getName();
    }

    @Override
    public int getMaximumLevel() {
        return this.enchantment.getMaximumLevel();
    }

    @Override
    public int getMinimumLevel() {
        return this.enchantment.getMinimumLevel();
    }

    @Override
    public boolean canBeAppliedToStack(WSItemStack itemStack) {
        return this.enchantment.canBeAppliedToStack(((SpongeItemStack)itemStack).getHandled());
    }

    @Override
    public boolean isCompatibleWith(WSEnchantment enchantment) {
        return this.enchantment.isCompatibleWith(((SpongeEnchantment)enchantment).getHandled());
    }

    public EnchantmentType getHandled() {
        return this.enchantment;
    }
}

