/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.item.enchantment;

import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.item.enchantment.WSEnchantment;
import com.degoos.wetsponge.item.enchantment.WSEnchantmentPrototype;
import com.degoos.wetsponge.text.translation.WSTranslation;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;

public class SpigotEnchantment
implements WSEnchantment {
    private Enchantment enchantment;

    public SpigotEnchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public SpigotEnchantment(int spigotId) {
        this.enchantment = Enchantment.getById((int)spigotId);
        if (this.enchantment == null) {
            this.enchantment = Enchantment.PROTECTION_ENVIRONMENTAL;
        }
    }

    public SpigotEnchantment(int id, final String name, final int minimumLevel, final int maximumLevel, final WSEnchantmentPrototype prototype) {
        this.enchantment = new Enchantment(id){

            public String getName() {
                return name;
            }

            public int getMaxLevel() {
                return maximumLevel;
            }

            public int getStartLevel() {
                return minimumLevel;
            }

            public EnchantmentTarget getItemTarget() {
                return EnchantmentTarget.ALL;
            }

            public boolean isTreasure() {
                return false;
            }

            public boolean isCursed() {
                return false;
            }

            public boolean conflictsWith(Enchantment enchantment) {
                return !prototype.isCompatibleWith(new SpigotEnchantment(enchantment));
            }

            public boolean canEnchantItem(ItemStack itemStack) {
                return prototype.canBeAppliedToStack(new SpigotItemStack(itemStack));
            }
        };
    }

    @Override
    public WSTranslation getTranslation() {
        throw new IllegalAccessError("Not supported by Spigot");
    }

    @Override
    public String getName() {
        return this.enchantment.getName();
    }

    @Override
    public int getMaximumLevel() {
        return this.enchantment.getMaxLevel();
    }

    @Override
    public int getMinimumLevel() {
        return this.enchantment.getStartLevel();
    }

    @Override
    public boolean canBeAppliedToStack(WSItemStack itemStack) {
        return this.enchantment.canEnchantItem(((SpigotItemStack)itemStack).getHandled());
    }

    @Override
    public boolean isCompatibleWith(WSEnchantment enchantment) {
        return !this.enchantment.conflictsWith(((SpigotEnchantment)enchantment).getHandled());
    }

    public Enchantment getHandled() {
        return this.enchantment;
    }
}

