/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.inventory;

import com.degoos.wetsponge.bridge.inventory.BridgeInventory;
import com.degoos.wetsponge.enums.EnumInventoryRows;
import com.degoos.wetsponge.inventory.WSSlotPos;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.text.WSText;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface WSInventory {
    public static WSInventory of(int size) {
        return BridgeInventory.of(size);
    }

    public static WSInventory of(int size, String title) {
        return WSInventory.of(size, WSText.getByFormattingText(title));
    }

    public static WSInventory of(int size, WSText title) {
        if (title == null) {
            return WSInventory.of(size);
        }
        return BridgeInventory.of(size, title);
    }

    public Optional<String> getName();

    public EnumInventoryRows getRows();

    public int size();

    public void setItem(WSItemStack var1, int var2);

    public void setItem(WSItemStack var1, WSSlotPos var2);

    public void addItem(WSItemStack var1);

    public Optional<WSItemStack> getItem(int var1);

    public Optional<WSItemStack> getItem(WSSlotPos var1);

    public void removeItem(int var1);

    public void removeItem(WSSlotPos var1);

    public List<WSItemStack> getContent();

    public Map<Integer, WSItemStack> getContentMap();

    public void setContents(Map<Integer, WSItemStack> var1);

    public int getSize();

    public void clear();

    public Object getHandled();
}

