/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.firework;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.enums.EnumFireworkShape;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.Validate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;

public class SpigotFireworkEffect
implements WSFireworkEffect {
    private FireworkEffect effect;

    public static WSFireworkEffect.Builder builder() {
        return new Builder(FireworkEffect.builder());
    }

    public SpigotFireworkEffect(FireworkEffect effect) {
        Validate.notNull(effect, "Effect cannot be null!");
        this.effect = effect;
    }

    @Override
    public boolean flickers() {
        return this.effect.hasFlicker();
    }

    @Override
    public boolean hasTrail() {
        return this.effect.hasTrail();
    }

    @Override
    public List<WSColor> getColors() {
        return this.effect.getColors().stream().map(color -> WSColor.ofRGB(color.asRGB())).collect(Collectors.toList());
    }

    @Override
    public List<WSColor> getFadeColors() {
        return this.effect.getFadeColors().stream().map(color -> WSColor.ofRGB(color.asRGB())).collect(Collectors.toList());
    }

    @Override
    public EnumFireworkShape getShape() {
        Optional<EnumFireworkShape> optional = EnumFireworkShape.getBySpigotName(this.effect.getType().name());
        if (!optional.isPresent()) {
            InternalLogger.sendError("Cannot found EnumFireworkShape for " + this.effect.getType().name() + ". Using the default one: " + (Object)((Object)EnumFireworkShape.BALL) + ".");
            return EnumFireworkShape.BALL;
        }
        return optional.get();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(FireworkEffect.builder().flicker(this.effect.hasFlicker()).trail(this.effect.hasTrail()).with(this.effect.getType()).withColor((Iterable)this.effect.getColors()).withFade((Iterable)this.effect.getFadeColors()));
    }

    @Override
    public WSFireworkEffect clone() {
        return this.toBuilder().build();
    }

    public FireworkEffect getHandled() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotFireworkEffect that = (SpigotFireworkEffect)o;
        return this.effect.equals((Object)that.effect);
    }

    public int hashCode() {
        return this.effect.hashCode();
    }

    protected static class Builder
    implements WSFireworkEffect.Builder {
        private FireworkEffect.Builder builder;

        public Builder(FireworkEffect.Builder builder) {
            this.builder = builder;
        }

        @Override
        public WSFireworkEffect.Builder trail(boolean trail) {
            this.builder.trail(trail);
            return this;
        }

        @Override
        public WSFireworkEffect.Builder flicker(boolean flicker) {
            this.builder.flicker(flicker);
            return this;
        }

        @Override
        public WSFireworkEffect.Builder color(WSColor color) {
            this.builder.withColor(Color.fromRGB((int)color.toRGB()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder colors(WSColor ... colors) {
            this.builder.withColor(ListUtils.toArray(Color.class, Arrays.stream(colors).map(color -> Color.fromRGB((int)color.toRGB())).collect(Collectors.toList())));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder colors(Collection<WSColor> colors) {
            this.builder.withColor((Iterable)colors.stream().map(color -> Color.fromRGB((int)color.toRGB())).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fade(WSColor color) {
            this.builder.withFade(Color.fromRGB((int)color.toRGB()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fades(WSColor ... colors) {
            this.builder.withFade(ListUtils.toArray(Color.class, Arrays.stream(colors).map(color -> Color.fromRGB((int)color.toRGB())).collect(Collectors.toList())));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder fades(Collection<WSColor> colors) {
            this.builder.withFade((Iterable)colors.stream().map(color -> Color.fromRGB((int)color.toRGB())).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WSFireworkEffect.Builder shape(EnumFireworkShape shape) {
            try {
                FireworkEffect.Type type = FireworkEffect.Type.valueOf((String)shape.getSpigotName());
                this.builder.with(type);
            }
            catch (Throwable ex) {
                InternalLogger.sendError("Cannot found FireworkShape (Sponge) for " + (Object)((Object)shape) + ". Using the default one: " + FireworkEffect.Type.BALL.name() + ".");
                this.builder.with(FireworkEffect.Type.BALL);
            }
            return this;
        }

        @Override
        public WSFireworkEffect build() {
            return new SpigotFireworkEffect(this.builder.build());
        }
    }
}

