/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.event.message;

import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.event.WSCancellable;
import com.degoos.wetsponge.event.WSEvent;
import com.degoos.wetsponge.text.WSText;
import java.util.Optional;
import java.util.Set;

public class WSChatEvent
extends WSEvent
implements WSCancellable {
    private WSPlayer player;
    private WSText originalMessage;
    private WSText rawMessage;
    private WSText header;
    private WSText body;
    private WSText footer;
    private boolean sendToConsole;
    private Set<WSPlayer> targets;
    private boolean cancelled;
    private boolean textChanged;

    public WSChatEvent(WSPlayer player, WSText originalMessage, WSText rawMessage, WSText header, WSText body, WSText footer, boolean sendToConsole, Set<WSPlayer> targets) {
        this.player = player;
        this.originalMessage = originalMessage;
        this.rawMessage = rawMessage;
        this.header = header;
        this.body = body;
        this.footer = footer;
        this.sendToConsole = sendToConsole;
        this.targets = targets;
        this.cancelled = false;
        this.textChanged = false;
    }

    public Optional<WSPlayer> getPlayer() {
        return Optional.ofNullable(this.player);
    }

    public WSText getMessage() {
        return this.header.toBuilder().append(this.body, this.footer).build();
    }

    public WSText getOriginalMessage() {
        return this.originalMessage;
    }

    public WSText getRawMessage() {
        return this.rawMessage;
    }

    public WSText getHeader() {
        return this.header;
    }

    public void setHeader(WSText header) {
        this.header = header == null ? WSText.empty() : header;
        this.textChanged = true;
    }

    public WSText getBody() {
        return this.body;
    }

    public void setBody(WSText body) {
        this.body = body == null ? WSText.empty() : body;
        this.textChanged = true;
    }

    public WSText getFooter() {
        return this.footer;
    }

    public void setFooter(WSText footer) {
        this.footer = footer == null ? WSText.empty() : footer;
        this.textChanged = true;
    }

    public boolean isSendToConsole() {
        return this.sendToConsole;
    }

    public void setSendToConsole(boolean sendToConsole) {
        this.sendToConsole = sendToConsole;
    }

    public Set<WSPlayer> getTargets() {
        return this.targets;
    }

    public void setTargets(Set<WSPlayer> targets) {
        this.targets = targets;
    }

    public boolean hasTextChanged() {
        return this.textChanged;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

