/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.other;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.effect.potion.SpongePotionEffect;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.other.WSAreaEffectCloud;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.particle.WSParticles;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.AreaEffectCloud;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Color;

public class SpongeAreaEffectCloud
extends SpongeEntity
implements WSAreaEffectCloud {
    public SpongeAreaEffectCloud(AreaEffectCloud entity) {
        super((Entity)entity);
    }

    @Override
    public WSColor getColor() {
        return WSColor.ofRGB(((Color)this.getHandled().color().get()).getRgb());
    }

    @Override
    public void setColor(WSColor color) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_COLOR, (Object)Color.ofRgb((int)color.toRGB()));
    }

    @Override
    public double getRadius() {
        return (Double)this.getHandled().radius().get();
    }

    @Override
    public void setRadius(double radius) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_RADIUS, (Object)radius);
    }

    @Override
    public WSParticle getParticle() {
        return WSParticles.getByMinecraftId(((ParticleType)this.getHandled().particleType().get()).getId()).orElse(WSParticles.SPLASH_POTION);
    }

    @Override
    public void setParticle(WSParticle particle) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, (Object)Sponge.getRegistry().getType(ParticleType.class, particle.getMinecraftId()).orElse(ParticleTypes.SPLASH_POTION));
    }

    @Override
    public int getDuration() {
        return (Integer)this.getHandled().duration().get();
    }

    @Override
    public void setDuration(int duration) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_DURATION, (Object)duration);
    }

    @Override
    public int getWaitTime() {
        return (Integer)this.getHandled().waitTime().get();
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, (Object)waitTime);
    }

    @Override
    public double getRadiusOnUse() {
        return (Double)this.getHandled().radiusOnUse().get();
    }

    @Override
    public void setRadiusOnUse(double radiusOnUse) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, (Object)radiusOnUse);
    }

    @Override
    public double getRadiusPerTick() {
        return (Double)this.getHandled().radiusPerTick().get();
    }

    @Override
    public void setRadiusPerTick(double radiusPerTick) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_RADIUS_PER_TICK, (Object)radiusPerTick);
    }

    @Override
    public int getDurationOnUse() {
        return (Integer)this.getHandled().durationOnUse().get();
    }

    @Override
    public void setDurationOnUse(int durationOnUse) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, (Object)durationOnUse);
    }

    @Override
    public int getApplicationDelay() {
        return (Integer)this.getHandled().applicationDelay().get();
    }

    @Override
    public void setApplicationDelay(int applicationDelay) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, (Object)applicationDelay);
    }

    @Override
    public int getAge() {
        return (Integer)this.getHandled().age().get();
    }

    @Override
    public void setAge(int age) {
        this.getHandled().offer(Keys.AREA_EFFECT_CLOUD_AGE, (Object)age);
    }

    @Override
    public void addPotionEffect(WSPotionEffect effect) {
        List list = (List)this.getHandled().effects().get();
        list.add(((SpongePotionEffect)effect).getHandled());
        this.getHandled().offer(Keys.POTION_EFFECTS, (Object)list);
    }

    @Override
    public List<WSPotionEffect> getPotionEffects() {
        return ((List)this.getHandled().effects().get()).stream().map(SpongePotionEffect::new).collect(Collectors.toList());
    }

    @Override
    public void clearAllPotionEffects() {
        this.getHandled().offer(Keys.POTION_EFFECTS, new ArrayList());
    }

    @Override
    public void removePotionEffect(EnumPotionEffectType potionEffectType) {
        this.getHandled().offer(Keys.POTION_EFFECTS, ((List)this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList())).stream().filter(potionEffect -> !potionEffect.getType().getName().equals(potionEffectType.name())).collect(Collectors.toList()));
    }

    public AreaEffectCloud getHandled() {
        return (AreaEffectCloud)super.getHandled();
    }
}

