/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.other;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.SpigotEntity;
import com.degoos.wetsponge.entity.other.WSFallingBlock;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;

public class SpigotFallingBlock
extends SpigotEntity
implements WSFallingBlock {
    private static Class<?> NMS_CLASS = NMSUtils.getNMSClass("EntityFallingBlock");

    public SpigotFallingBlock(FallingBlock entity) {
        super((Entity)entity);
    }

    @Override
    public WSBlockType getBlockType() {
        return ((SpigotBlockType)WSBlockTypes.getById(this.getHandled().getMaterial().getId()).orElse(WSBlockTypes.AIR.getDefaultState())).readMaterialData(this.getHandled().getMaterial().getNewData(this.getHandled().getBlockData()));
    }

    @Override
    public void setBlockType(WSBlockType blockType) {
        Validate.notNull(blockType, "Block type cannot be null!");
        try {
            ReflectionUtils.setFirstObject(NMS_CLASS, NMSUtils.getNMSClass("IBlockData"), SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), SpigotHandledUtils.getBlockState(blockType));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
        }
    }

    @Override
    public double getFallDamagePerBlock() {
        try {
            return (Double)ReflectionUtils.getObject(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), "fallHurtAmount");
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
            return 0.0;
        }
    }

    @Override
    public void setFallDamagerPerBlock(double fallDamagerPerBlock) {
        try {
            ReflectionUtils.setAccessible(ReflectionUtils.getField(NMS_CLASS, "fallHurtAmount")).setDouble(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), fallDamagerPerBlock);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
        }
    }

    @Override
    public double getMaxFallDamage() {
        try {
            return (Double)ReflectionUtils.getObject(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), "fallHurtMax");
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
            return 0.0;
        }
    }

    @Override
    public void setMaxFallDamage(double maxFallDamage) {
        try {
            ReflectionUtils.setAccessible(ReflectionUtils.getField(NMS_CLASS, "fallHurtMax")).setDouble(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), maxFallDamage);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
        }
    }

    @Override
    public boolean canPlaceAsBlock() {
        try {
            return (Boolean)ReflectionUtils.getObject(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "f" : "e");
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
            return false;
        }
    }

    @Override
    public void setCanPlaceAsBlock(boolean canPlaceAsBlock) {
        try {
            ReflectionUtils.setAccessible(ReflectionUtils.getField(NMS_CLASS, WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "f" : "e")).setBoolean(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), canPlaceAsBlock);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
        }
    }

    @Override
    public boolean canDropAsItem() {
        return this.getHandled().getDropItem();
    }

    @Override
    public void setCanDropAsItem(boolean canDropAsItem) {
        this.getHandled().setDropItem(canDropAsItem);
    }

    @Override
    public int getFallTime() {
        try {
            return (Integer)ReflectionUtils.getObject(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), "ticksLived");
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
            return 0;
        }
    }

    @Override
    public void setFallTime(int fallTime) {
        try {
            ReflectionUtils.setAccessible(ReflectionUtils.getField(NMS_CLASS, "ticksLived")).setInt(SpigotHandledUtils.getEntityHandle((Entity)this.getHandled()), fallTime);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a FallingBlock!");
        }
    }

    @Override
    public boolean canHurtEntities() {
        return this.getHandled().canHurtEntities();
    }

    @Override
    public void setCanHurtEntities(boolean canHurtEntities) {
        this.getHandled().setHurtEntities(canHurtEntities);
    }

    public FallingBlock getHandled() {
        return (FallingBlock)super.getHandled();
    }
}

