/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.player;

import com.degoos.wetsponge.bridge.sound.BridgeSound;
import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.enums.EnumSoundCategory;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.WSPacket;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.sound.WSSound;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.WSTitle;
import com.degoos.wetsponge.user.WSUser;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public interface WSPlayer
extends WSHuman,
WSCommandSource,
WSUser {
    public WSText getDisplayedName();

    public void setDisplayedName(WSText var1);

    public void spawnParticle(WSLocation var1, float var2, int var3, WSParticle var4);

    public void spawnParticle(WSLocation var1, float var2, int var3, Vector3f var4, WSParticle var5);

    default public void moveToWorld(WSWorld world) {
        Vector3i vector3i = world.getProperties().getSpawnPosition();
        if (vector3i == null) {
            vector3i = new Vector3i(0, 1, 0);
        }
        this.setLocation(WSLocation.of(world, vector3i));
    }

    public void kick();

    public void kick(WSText var1);

    public void simulateMessage(WSText var1);

    public WSScoreboard getScoreboard();

    public void setScoreboard(WSScoreboard var1);

    default public void playSound(String sound, float volume) {
        this.playSound(sound, volume, 1.0f);
    }

    default public void playSound(String sound, float volume, float pitch) {
        this.playSound(sound, volume, pitch, EnumSoundCategory.VOICE);
    }

    default public void playSound(String sound, float volume, float pitch, EnumSoundCategory category) {
        this.playSound(sound, volume, pitch, category, this.getLocation().toVector3d());
    }

    default public void playSound(String sound, float volume, float pitch, Vector3d position) {
        this.playSound(sound, volume, pitch, EnumSoundCategory.VOICE, position);
    }

    default public void playSound(String sound, float volume, float pitch, EnumSoundCategory category, Vector3d position) {
        BridgeSound.playSound(sound, volume, pitch, category, position, this);
    }

    default public void playSound(WSSound sound, float volume) {
        sound.playSound(this, volume);
    }

    default public void playSound(WSSound sound, float volume, float pitch) {
        sound.playSound(this, volume, pitch);
    }

    default public void playSound(WSSound sound, float volume, float pitch, EnumSoundCategory category) {
        sound.playSound(this, volume, pitch, category);
    }

    default public void playSound(WSSound sound, float volume, float pitch, Vector3d position) {
        sound.playSound(this, volume, pitch, position);
    }

    default public void playSound(WSSound sound, float volume, float pitch, EnumSoundCategory category, Vector3d position) {
        sound.playSound(this, volume, pitch, category, position);
    }

    public void sendTitle(WSTitle var1);

    public void setResourcePack(URI var1);

    public String getLanguageCode();

    @Override
    public boolean isOnline();

    public float getExperience();

    public void setExperience(float var1);

    public int getExperienceLevel();

    public void setExperienceLevel(int var1);

    public double getWalkingSpeed();

    public void setWalkingSpeed(double var1);

    public double getFlyingSpeed();

    public void setFlyingSpeed(double var1);

    public boolean canFly();

    public void setCanFly(boolean var1);

    public boolean isFlying();

    public void setFlying(boolean var1);

    public void addFakeBlock(WSLocation var1, WSBlockType var2);

    public Optional<WSBlockType> getFakeBlock(WSLocation var1);

    public Map<WSLocation, WSBlockType> getFakeBlocks();

    public boolean containsFakeBlock(WSLocation var1);

    public void refreshFakeBlock(WSLocation var1);

    public void removeFakeBlock(WSLocation var1);

    public void clearFakeBlocks();

    public void sendPacket(WSPacket var1);

    public int getSelectedHotbarSlot();

    public void setSelectedHotbarSlot(int var1);

    public void sendSignChange(WSLocation var1, WSText[] var2);

    public int getPing();
}

