/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.player;

import com.degoos.wetsponge.entity.living.SpongeLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.inventory.SpongeInventory;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.Human;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;

public class SpongeHuman
extends SpongeLivingEntity
implements WSHuman {
    public SpongeHuman(Human entity) {
        super((Living)entity);
    }

    @Override
    public int getFoodLevel() {
        return (Integer)this.getHandled().foodLevel().get();
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.getHandled().foodLevel().set((Object)foodLevel);
    }

    @Override
    public WSInventory getInventory() {
        return new SpongeInventory((Inventory)this.getHandled().getInventory());
    }

    @Override
    public WSInventory getEnderChestInventory() {
        return new SpongeInventory((Inventory)((EntityPlayer)this.getHandled()).func_71005_bN());
    }

    @Override
    public Optional<WSInventory> getOpenInventory() {
        return Optional.ofNullable(((EntityPlayer)this.getHandled()).field_71070_bA).map(inventory -> new SpongeInventory((Inventory)inventory));
    }

    @Override
    public void openInventory(WSInventory inventory) {
        if (inventory == null) {
            this.closeInventory();
        }
    }

    @Override
    public void closeInventory() {
    }

    @Override
    public Optional<WSItemStack> getItemOnCursor() {
        ItemStack itemStack = (ItemStack)((EntityPlayer)this.getHandled()).field_71071_by.func_70445_o();
        if (itemStack == null || itemStack.getItem().getId().equals(ItemTypes.AIR.getId())) {
            return Optional.empty();
        }
        return Optional.of(new SpongeItemStack(itemStack));
    }

    @Override
    public void setItemOnCursor(WSItemStack itemOnCursor) {
        if (itemOnCursor == null) {
            ((EntityPlayer)this.getHandled()).field_71071_by.func_70437_b(net.minecraft.item.ItemStack.field_190927_a);
        } else {
            ((EntityPlayer)this.getHandled()).field_71071_by.func_70437_b((net.minecraft.item.ItemStack)((SpongeItemStack)itemOnCursor).getHandled());
        }
    }

    @Override
    public EnumGameMode getGameMode() {
        return EnumGameMode.SURVIVAL;
    }

    @Override
    public void setGameMode(EnumGameMode gameMode) {
    }

    @Override
    public WSGameProfile getProfile() {
        return new SpongeGameProfile((GameProfile)((EntityPlayer)this.getHandled()).func_146103_bH());
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        Optional itemStack;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.MAIN_HAND);
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.OFF_HAND);
                break;
            }
            default: {
                itemStack = Optional.empty();
            }
        }
        return itemStack.map(SpongeItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().setHelmet(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().setChestplate(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case LEGGINGS: {
                this.getHandled().setLeggings(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case BOOTS: {
                this.getHandled().setBoots(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().setItemInHand(HandTypes.MAIN_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case OFF_HAND: {
                this.getHandled().setItemInHand(HandTypes.OFF_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
            }
        }
    }

    @Override
    public boolean hasPermission(String name) {
        return false;
    }

    @Override
    public Set<String> getPermissions() {
        return new HashSet<String>();
    }

    public Human getHandled() {
        return (Human)super.getHandled();
    }
}

