/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.player;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.SpigotLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.inventory.SpigotInventory;
import com.degoos.wetsponge.inventory.WSInventory;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.user.SpigotGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class SpigotHuman
extends SpigotLivingEntity
implements WSHuman {
    public SpigotHuman(HumanEntity entity) {
        super((LivingEntity)entity);
    }

    @Override
    public int getFoodLevel() {
        return 20;
    }

    @Override
    public void setFoodLevel(int foodLevel) {
    }

    @Override
    public WSInventory getInventory() {
        return new SpigotInventory((Inventory)this.getHandled().getInventory());
    }

    @Override
    public WSInventory getEnderChestInventory() {
        return new SpigotInventory(this.getHandled().getEnderChest());
    }

    @Override
    public Optional<WSInventory> getOpenInventory() {
        return Optional.ofNullable(this.getHandled().getOpenInventory().getTopInventory()).map(SpigotInventory::new);
    }

    @Override
    public void openInventory(WSInventory inventory) {
        if (inventory == null) {
            this.closeInventory();
        } else {
            this.getHandled().openInventory(((SpigotInventory)inventory).getHandled());
        }
    }

    @Override
    public void closeInventory() {
        this.getHandled().closeInventory();
    }

    @Override
    public Optional<WSItemStack> getItemOnCursor() {
        ItemStack itemStack = this.getHandled().getItemOnCursor();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return Optional.empty();
        }
        return Optional.of(new SpigotItemStack(itemStack));
    }

    @Override
    public void setItemOnCursor(WSItemStack itemOnCursor) {
        if (itemOnCursor == null) {
            this.getHandled().setItemOnCursor(null);
        } else {
            this.getHandled().setItemOnCursor(((SpigotItemStack)itemOnCursor).getHandled());
        }
    }

    @Override
    public EnumGameMode getGameMode() {
        return EnumGameMode.getByValue(this.getHandled().getGameMode().getValue()).orElse(EnumGameMode.SURVIVAL);
    }

    @Override
    public void setGameMode(EnumGameMode gameMode) {
        this.getHandled().setGameMode(GameMode.getByValue((int)gameMode.getValue()));
    }

    @Override
    public WSGameProfile getProfile() {
        Object handled = SpigotHandledUtils.getHandle(this.getHandled());
        try {
            return new SpigotGameProfile((GameProfile)ReflectionUtils.invokeMethod(handled, "getProfile", new Object[0]));
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An exception has occurred while WetSponge was getting a human's profile!");
            return null;
        }
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        ItemStack itemStack = null;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getEquipment().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getEquipment().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getEquipment().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getEquipment().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getEquipment().getItemInHand();
                break;
            }
            case OFF_HAND: {
                itemStack = !WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? null : this.getHandled().getEquipment().getItemInOffHand();
            }
        }
        return Optional.ofNullable(itemStack).map(SpigotItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().getEquipment().setHelmet(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().getEquipment().setChestplate(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case LEGGINGS: {
                this.getHandled().getEquipment().setLeggings(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case BOOTS: {
                this.getHandled().getEquipment().setBoots(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().getEquipment().setItemInHand(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case OFF_HAND: {
                if (!WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) break;
                this.getHandled().getEquipment().setItemInOffHand(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
            }
        }
    }

    @Override
    public boolean hasPermission(String name) {
        return this.getHandled().hasPermission(name);
    }

    @Override
    public Set<String> getPermissions() {
        return this.getHandled().getEffectivePermissions().stream().map(PermissionAttachmentInfo::getPermission).collect(Collectors.toSet());
    }

    public HumanEntity getHandled() {
        return (HumanEntity)super.getHandled();
    }
}

