/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.entity.living.monster.SpigotMonster;
import com.degoos.wetsponge.entity.living.monster.WSSkeleton;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import java.util.Optional;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;

public class SpigotSkeleton
extends SpigotMonster
implements WSSkeleton {
    public SpigotSkeleton(Skeleton entity) {
        super((Monster)entity);
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        ItemStack itemStack = null;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getEquipment().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getEquipment().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getEquipment().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getEquipment().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getEquipment().getItemInHand();
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getEquipment().getItemInOffHand();
            }
        }
        return Optional.ofNullable(itemStack).map(SpigotItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().getEquipment().setHelmet(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().getEquipment().setChestplate(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case LEGGINGS: {
                this.getHandled().getEquipment().setLeggings(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case BOOTS: {
                this.getHandled().getEquipment().setBoots(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().getEquipment().setItemInHand(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
                break;
            }
            case OFF_HAND: {
                this.getHandled().getEquipment().setItemInOffHand(itemStack == null ? null : ((SpigotItemStack)itemStack).getHandled().clone());
            }
        }
    }

    public Skeleton getHandled() {
        return (Skeleton)super.getHandled();
    }
}

