/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.golem;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.Spigot13Creature;
import com.degoos.wetsponge.entity.living.golem.WSSnowGolem;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Snowman;

public class Spigot13SnowGolem
extends Spigot13Creature
implements WSSnowGolem {
    public Spigot13SnowGolem(Snowman entity) {
        super((Creature)entity);
    }

    @Override
    public boolean hasPumpkinEquipped() {
        if (!WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return true;
        }
        try {
            return (Boolean)NMSUtils.getNMSClass("EntitySnowman").getMethod("hasPumpkin", new Class[0]).invoke(Spigot13HandledUtils.getEntityHandle((Entity)this.getHandled()), new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was checking if a snow golem has a pumpkin!");
            return true;
        }
    }

    @Override
    public void setPumpkinEquipped(boolean pumpkinEquipped) {
        if (!WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return;
        }
        try {
            NMSUtils.getNMSClass("EntitySnowman").getMethod("setHasPumpkin", Boolean.TYPE).invoke(Spigot13HandledUtils.getEntityHandle((Entity)this.getHandled()), pumpkinEquipped);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting whether a snow golem has a pumpkin!");
        }
    }

    public Snowman getHandled() {
        return (Snowman)super.getHandled();
    }
}

