/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSSheep;
import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.util.Validate;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Sheep;

public class SpongeSheep
extends SpongeAnimal
implements WSSheep {
    public SpongeSheep(Sheep entity) {
        super((Animal)entity);
    }

    @Override
    public Optional<EnumDyeColor> getColor() {
        return EnumDyeColor.getByName(((DyeColor)this.getHandled().color().get()).getName());
    }

    @Override
    public void setColor(EnumDyeColor color) {
        Validate.notNull((Object)color, "WSColor cannot be null!");
        this.getHandled().offer(Keys.DYE_COLOR, (Object)this.getDyeColor(color));
    }

    @Override
    public boolean isSheared() {
        Optional optional = this.getHandled().get(Keys.IS_SHEARED);
        return optional.orElse(false);
    }

    @Override
    public void setSheared(boolean sheared) {
        this.getHandled().offer(Keys.IS_SHEARED, (Object)sheared);
    }

    public Sheep getHandled() {
        return (Sheep)super.getHandled();
    }

    private DyeColor getDyeColor(EnumDyeColor color) {
        switch (color) {
            case WHITE: {
                return DyeColors.WHITE;
            }
            case ORANGE: {
                return DyeColors.ORANGE;
            }
            case MAGENTA: {
                return DyeColors.MAGENTA;
            }
            case LIGHT_BLUE: {
                return DyeColors.LIGHT_BLUE;
            }
            case YELLOW: {
                return DyeColors.YELLOW;
            }
            case LIME: {
                return DyeColors.LIME;
            }
            case PINK: {
                return DyeColors.PINK;
            }
            case GRAY: {
                return DyeColors.GRAY;
            }
            case LIGHT_GRAY: {
                return DyeColors.SILVER;
            }
            case CYAN: {
                return DyeColors.CYAN;
            }
            case PURPLE: {
                return DyeColors.PURPLE;
            }
            case BLUE: {
                return DyeColors.BLUE;
            }
            case BROWN: {
                return DyeColors.BROWN;
            }
            case GREEN: {
                return DyeColors.GREEN;
            }
            case RED: {
                return DyeColors.RED;
            }
            case BLACK: {
                return DyeColors.BLACK;
            }
        }
        return DyeColors.WHITE;
    }
}

