/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSRabbit;
import com.degoos.wetsponge.enums.EnumRabbitType;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.RabbitType;
import org.spongepowered.api.data.type.RabbitTypes;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Rabbit;

public class SpongeRabbit
extends SpongeAnimal
implements WSRabbit {
    public SpongeRabbit(Rabbit entity) {
        super((Animal)entity);
    }

    @Override
    public Optional<EnumRabbitType> getRabbitType() {
        return EnumRabbitType.getRabbitType(((RabbitType)this.getHandled().variant().get()).getName());
    }

    @Override
    public void setRabbitType(EnumRabbitType rabbitType) {
        this.getHandled().offer(Keys.RABBIT_TYPE, (Object)this.getRabbitType(rabbitType));
    }

    public Rabbit getHandled() {
        return (Rabbit)super.getHandled();
    }

    private RabbitType getRabbitType(EnumRabbitType rabbitType) {
        switch (rabbitType) {
            case BROWN: {
                return RabbitTypes.BROWN;
            }
            case WHITE: {
                return RabbitTypes.WHITE;
            }
            case BLACK: {
                return RabbitTypes.BLACK;
            }
            case BLACK_AND_WHITE: {
                return RabbitTypes.BLACK_AND_WHITE;
            }
            case GOLD: {
                return RabbitTypes.GOLD;
            }
            case SALT_AND_PEPPER: {
                return RabbitTypes.SALT_AND_PEPPER;
            }
            case THE_KILLER_BUNNY: {
                return RabbitTypes.KILLER;
            }
        }
        return RabbitTypes.BROWN;
    }
}

