/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSParrot;
import com.degoos.wetsponge.enums.EnumParrotVariant;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.ParrotVariant;
import org.spongepowered.api.data.type.ParrotVariants;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Parrot;

public class SpongeParrot
extends SpongeAnimal
implements WSParrot {
    public SpongeParrot(Parrot entity) {
        super((Animal)entity);
    }

    @Override
    public EnumParrotVariant getVariant() {
        return EnumParrotVariant.valueOf(this.getHandled().get(Keys.PARROT_VARIANT).orElse(ParrotVariants.BLUE).getId());
    }

    @Override
    public void setVariant(EnumParrotVariant variant) {
        this.getHandled().offer(Keys.PARROT_VARIANT, Sponge.getRegistry().getType(ParrotVariant.class, variant.name()).orElseThrow(NullPointerException::new));
    }

    @Override
    public boolean isSitting() {
        return this.getHandled().get(Keys.IS_SITTING).orElse(false);
    }

    @Override
    public void setSitting(boolean sitting) {
        this.getHandled().offer(Keys.IS_SITTING, (Object)sitting);
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public Optional<UUID> getTamer() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().offer(Keys.TAMED_OWNER, Optional.ofNullable(tamer));
    }

    public Parrot getHandled() {
        return (Parrot)super.getHandled();
    }
}

