/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.Spigot13AbstractHorse;
import com.degoos.wetsponge.entity.living.animal.WSLlama;
import com.degoos.wetsponge.enums.EnumLlamaType;
import com.degoos.wetsponge.inventory.Spigot13Inventory;
import com.degoos.wetsponge.inventory.WSInventory;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.Inventory;

public class Spigot13Llama
extends Spigot13AbstractHorse
implements WSLlama {
    public Spigot13Llama(Llama entity) {
        super((AbstractHorse)entity);
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().isTamed();
    }

    @Override
    public Optional<UUID> getTamer() {
        AnimalTamer tamer = this.getHandled().getOwner();
        if (tamer == null) {
            return Optional.empty();
        }
        return Optional.of(tamer.getUniqueId());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().setOwner((AnimalTamer)(tamer == null ? null : Bukkit.getOfflinePlayer((UUID)tamer)));
    }

    public Llama getHandled() {
        return (Llama)super.getHandled();
    }

    @Override
    public EnumLlamaType getLlamaType() {
        return EnumLlamaType.getByName(this.getHandled().getColor().toString()).orElse(EnumLlamaType.CREAMY);
    }

    @Override
    public void setLlamaType(EnumLlamaType type) {
        this.getHandled().setColor(Arrays.stream(Llama.Color.values()).filter(target -> target.name().equalsIgnoreCase(type.toString())).findAny().orElse(Llama.Color.CREAMY));
    }

    @Override
    public WSInventory getInventory() {
        return new Spigot13Inventory((Inventory)this.getHandled().getInventory());
    }

    @Override
    public boolean hasChest() {
        return this.getHandled().isCarryingChest();
    }

    @Override
    public void setChested(boolean chested) {
        this.getHandled().setCarryingChest(chested);
    }
}

