/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living;

import com.degoos.wetsponge.entity.living.SpongeLivingEntity;
import com.degoos.wetsponge.entity.living.WSArmorStand;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Living;

public class SpongeArmorStand
extends SpongeLivingEntity
implements WSArmorStand {
    public SpongeArmorStand(ArmorStand entity) {
        super((Living)entity);
    }

    @Override
    public Vector3d getHeadDirection() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().headDirection().get();
    }

    @Override
    public void setHeadDirection(Vector3d headDirection) {
        this.getHandled().offer(Keys.HEAD_ROTATION, (Object)headDirection);
    }

    @Override
    public Vector3d getBodyRotation() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().bodyRotation().get();
    }

    @Override
    public void setBodyRotation(Vector3d bodyRotation) {
        this.getHandled().offer(Keys.CHEST_ROTATION, (Object)bodyRotation);
    }

    @Override
    public Vector3d getLeftArmDirection() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().leftArmDirection().get();
    }

    @Override
    public void setLeftArmDirection(Vector3d leftArmDirection) {
        this.getHandled().offer(Keys.LEFT_ARM_ROTATION, (Object)leftArmDirection);
    }

    @Override
    public Vector3d getRightArmDirection() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().rightArmDirection().get();
    }

    @Override
    public void setRightArmDirection(Vector3d rightArmDirection) {
        this.getHandled().offer(Keys.RIGHT_ARM_ROTATION, (Object)rightArmDirection);
    }

    @Override
    public Vector3d getLeftLegDirection() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().leftLegDirection().get();
    }

    @Override
    public void setLeftLegDirection(Vector3d leftLegDirection) {
        this.getHandled().offer(Keys.LEFT_LEG_ROTATION, (Object)leftLegDirection);
    }

    @Override
    public Vector3d getRightLegDirection() {
        return (Vector3d)this.getHandled().getBodyPartRotationalData().rightLegDirection().get();
    }

    @Override
    public void setRightLegDirection(Vector3d rightLegDirection) {
        this.getHandled().offer(Keys.RIGHT_LEG_ROTATION, (Object)rightLegDirection);
    }

    @Override
    public boolean isMarker() {
        return (Boolean)this.getHandled().marker().get();
    }

    @Override
    public void setMarker(boolean marker) {
        this.getHandled().offer(Keys.ARMOR_STAND_MARKER, (Object)marker);
    }

    @Override
    public boolean isSmall() {
        return (Boolean)this.getHandled().small().get();
    }

    @Override
    public void setSmall(boolean small) {
        this.getHandled().offer(Keys.ARMOR_STAND_IS_SMALL, (Object)small);
    }

    @Override
    public boolean hasBasePlate() {
        return (Boolean)this.getHandled().basePlate().get();
    }

    @Override
    public void setBasePlate(boolean basePlate) {
        this.getHandled().offer(Keys.ARMOR_STAND_HAS_BASE_PLATE, (Object)basePlate);
    }

    @Override
    public boolean hasArms() {
        return (Boolean)this.getHandled().arms().get();
    }

    @Override
    public void setArms(boolean arms) {
        this.getHandled().offer(Keys.ARMOR_STAND_HAS_ARMS, (Object)arms);
    }

    @Override
    public boolean hasGravity() {
        return (Boolean)this.getHandled().gravity().get();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.getHandled().offer(Keys.HAS_GRAVITY, (Object)gravity);
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        Optional itemStack;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.MAIN_HAND);
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getItemInHand(HandTypes.OFF_HAND);
                break;
            }
            default: {
                itemStack = Optional.empty();
            }
        }
        return itemStack.map(SpongeItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().setHelmet(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().setChestplate(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case LEGGINGS: {
                this.getHandled().setLeggings(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case BOOTS: {
                this.getHandled().setBoots(itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().setItemInHand(HandTypes.MAIN_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
                break;
            }
            case OFF_HAND: {
                this.getHandled().setItemInHand(HandTypes.OFF_HAND, itemStack == null ? null : ((SpongeItemStack)itemStack).getHandled());
            }
        }
    }

    public ArmorStand getHandled() {
        return (ArmorStand)super.getHandled();
    }
}

