/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.SpigotLivingEntity;
import com.degoos.wetsponge.entity.living.WSCreature;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.degoos.wetsponge.util.reflection.SpigotEntityUtils;
import java.util.Optional;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class SpigotCreature
extends SpigotLivingEntity
implements WSCreature {
    public SpigotCreature(Creature entity) {
        super((LivingEntity)entity);
    }

    @Override
    public void setAI(boolean ai) {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            this.getHandled().setAI(ai);
        } else {
            SpigotEntityUtils.setAI((Entity)this.getHandled(), ai);
        }
    }

    @Override
    public boolean hasAI() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return this.getHandled().hasAI();
        }
        return SpigotEntityUtils.hasAI((Entity)this.getHandled());
    }

    @Override
    public Optional<WSEntity> getTarget() {
        return Optional.ofNullable(this.getHandled().getTarget()).map(SpigotEntityParser::getWSEntity);
    }

    @Override
    public void setTarget(WSEntity entity) {
        if (entity == null) {
            this.getHandled().setTarget(null);
        } else if (entity instanceof SpigotLivingEntity) {
            this.getHandled().setTarget(((SpigotLivingEntity)entity).getHandled());
        }
    }

    public Creature getHandled() {
        return (Creature)super.getHandled();
    }
}

