/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.explosive;

import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.explosive.WSPrimedTNT;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.PrimedTNT;

public class SpongePrimedTNT
extends SpongeEntity
implements WSPrimedTNT {
    public SpongePrimedTNT(PrimedTNT entity) {
        super((Entity)entity);
    }

    @Override
    public Optional<WSLivingEntity> getDetonator() {
        return this.getHandled().getDetonator().map(SpongeEntityParser::getWSEntity).map(t -> (WSLivingEntity)t);
    }

    @Override
    public void setDetonator(WSLivingEntity entity) {
        try {
            ReflectionUtils.setFirstObject(EntityTNTPrimed.class, EntityLivingBase.class, this.getHandled(), entity == null ? null : entity.getHandled());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the detonator of a primed TNT!");
        }
    }

    @Override
    public int getFuseDuration() {
        return (Integer)this.getHandled().getFuseData().fuseDuration().get();
    }

    @Override
    public void setFuseDuration(int fuseDuration) {
        this.getHandled().offer(Keys.FUSE_DURATION, (Object)fuseDuration);
    }

    @Override
    public int getTicksRemaining() {
        return (Integer)this.getHandled().getFuseData().ticksRemaining().get();
    }

    @Override
    public void setTicksRemaining(int ticksRemaining) {
        this.getHandled().offer(Keys.TICKS_REMAINING, (Object)ticksRemaining);
    }

    @Override
    public boolean isPrimed() {
        return this.getHandled().isPrimed();
    }

    @Override
    public void prime() {
        this.getHandled().prime();
    }

    @Override
    public void defuse() {
        this.getHandled().defuse();
    }

    @Override
    public int setExplosionRadius() {
        return ((Optional)this.getHandled().getExplosionRadiusData().explosionRadius().get()).orElse(2);
    }

    @Override
    public void setExplosionRadius(int explosionRadius) {
        this.getHandled().offer(Keys.EXPLOSION_RADIUS, Optional.of(explosionRadius));
    }

    @Override
    public void detonate() {
        this.getHandled().detonate();
    }

    public PrimedTNT getHandled() {
        return (PrimedTNT)super.getHandled();
    }
}

