/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity;

import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.translation.WSTranslatable;
import com.degoos.wetsponge.world.WSLocatable;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector3d;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public interface WSEntity
extends WSLocatable,
WSTranslatable {
    public UUID getUniqueId();

    public EnumEntityType getEntityType();

    public boolean isDead();

    public boolean isOnGround();

    public void setLocation(WSLocation var1);

    public Vector3d getVelocity();

    public void setVelocity(Vector3d var1);

    public Vector3d getRotation();

    public void setRotation(Vector3d var1);

    public Optional<WSText> getCustomName();

    public void setCustomName(WSText var1);

    public boolean isCustomNameVisible();

    public void setCustomNameVisible(boolean var1);

    public Set<WSEntity> getPassengers();

    public boolean addPassenger(WSEntity var1);

    public Optional<WSEntity> getRidingEntity();

    public void mountEntity(WSEntity var1);

    public void dismountRidingEntity();

    public boolean isRiding();

    public boolean isBeingRidden();

    public int getEntityId();

    public void addProperty(String var1, Object var2);

    public void addProperty(String var1, Object var2, boolean var3);

    public Optional<Object> getProperty(String var1);

    public <T> Optional<T> getProperty(String var1, Class<T> var2);

    public void removeProperty(String var1);

    public Map<String, Object> getProperties();

    public boolean hasGravity();

    public void setGravity(boolean var1);

    public boolean isGlowing();

    public void setGlowing(boolean var1);

    public boolean isSilent();

    public void setSilent(boolean var1);

    public boolean isInvisible();

    public void setInvisible(boolean var1);

    public boolean isInvincible();

    public void setInvincible(boolean var1);

    public void setInvincibleMillis(int var1);

    public int getAir();

    public void setAir(int var1);

    public int getFireTicks();

    public void setFireTicks(int var1);

    public int getMaxFireTicks();

    public float getFallDistance();

    public void setFallDistance(float var1);

    public Vector3d getEntitySize();

    public WSNBTTagCompound writeToNBTTagCompound(WSNBTTagCompound var1);

    public WSNBTTagCompound writeToNBTTagCompoundAtomically(WSNBTTagCompound var1);

    public WSNBTTagCompound writeToNBTTagCompoundOptional(WSNBTTagCompound var1);

    public WSNBTTagCompound readFromNBTTagCompound(WSNBTTagCompound var1);

    public void remove();

    public Object getHandled();
}

