/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.translation.WSTranslation;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.degoos.wetsponge.world.SpigotLocation;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector3d;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class SpigotEntity
implements WSEntity {
    private Entity entity;
    private EnumEntityType entityType;
    private Map<String, Object> properties;
    private boolean invincible;
    private long invincibleMillis;

    public SpigotEntity(Entity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.entity = entity;
        this.entityType = SpigotEntityParser.getEntityType(entity);
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public UUID getUniqueId() {
        return this.entity.getUniqueId();
    }

    @Override
    public EnumEntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public boolean isDead() {
        return this.entity.isDead();
    }

    @Override
    public boolean isOnGround() {
        return this.entity.isOnGround();
    }

    @Override
    public WSLocation getLocation() {
        return new SpigotLocation(this.entity.getLocation());
    }

    @Override
    public void setLocation(WSLocation location) {
        this.entity.teleport(new Location(((SpigotLocation)location).getWorld().getHandled(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.entity.getWorld().getName(), this.entity.getWorld());
    }

    @Override
    public Vector3d getVelocity() {
        Vector vector = this.entity.getVelocity();
        return new Vector3d(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public void setVelocity(Vector3d velocity) {
        this.entity.setVelocity(new Vector(velocity.getX(), velocity.getY(), velocity.getZ()));
    }

    @Override
    public Vector3d getRotation() {
        Location location = this.entity.getLocation();
        return new Vector3d(location.getYaw(), location.getPitch(), 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        this.setLocation(this.getLocation().setYaw((float)rotation.getX()).setPitch((float)rotation.getY()));
    }

    @Override
    public Optional<WSText> getCustomName() {
        return Optional.ofNullable(this.entity.getCustomName()).map(WSText::getByFormattingText);
    }

    @Override
    public void setCustomName(@Nullable WSText customName) {
        if (customName == null) {
            this.entity.setCustomName(null);
        } else {
            this.entity.setCustomName(customName.toFormattingText());
        }
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.entity.isCustomNameVisible();
    }

    @Override
    public void setCustomNameVisible(boolean customNameVisible) {
        this.entity.setCustomNameVisible(customNameVisible);
    }

    @Override
    public Set<WSEntity> getPassengers() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return this.entity.getPassengers().stream().map(SpigotEntityParser::getWSEntity).collect(Collectors.toSet());
        }
        Entity target = this.entity.getPassenger();
        HashSet<WSEntity> set = new HashSet<WSEntity>();
        if (target != null) {
            set.add(SpigotEntityParser.getWSEntity(target));
        }
        return set;
    }

    @Override
    public boolean addPassenger(WSEntity entity) {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return this.entity.addPassenger(((SpigotEntity)entity).entity);
        }
        return this.getHandled().setPassenger(((SpigotEntity)entity).entity);
    }

    @Override
    public Optional<WSEntity> getRidingEntity() {
        try {
            return Optional.ofNullable(this.entity.getVehicle()).map(SpigotEntityParser::getWSEntity);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public void mountEntity(WSEntity entity) {
        try {
            Class<?> clazz = NMSUtils.getNMSClass("Entity");
            clazz.getMethod(WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "startRiding" : "mount", clazz).invoke(SpigotHandledUtils.getEntityHandle(this.entity), SpigotHandledUtils.getEntityHandle(((SpigotEntity)entity).entity));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void dismountRidingEntity() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            try {
                Object handled = SpigotHandledUtils.getEntityHandle(this.entity);
                NMSUtils.getNMSClass("Entity").getMethod("stopRiding", new Class[0]).invoke(handled, new Object[0]);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                Class<?> clazz = NMSUtils.getNMSClass("Entity");
                clazz.getMethod("mount", clazz).invoke(SpigotHandledUtils.getEntityHandle(this.entity), new Object[]{null});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean isRiding() {
        try {
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                return (Boolean)NMSUtils.getNMSClass("Entity").getMethod("isPassenger", new Class[0]).invoke(SpigotHandledUtils.getEntityHandle(this.entity), new Object[0]);
            }
            return NMSUtils.getNMSClass("Entity").getField("vehicle").get(SpigotHandledUtils.getEntityHandle(this.entity)) != null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isBeingRidden() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            try {
                return (Boolean)NMSUtils.getNMSClass("Entity").getMethod("isVehicle", new Class[0]).invoke((Object)this.entity, new Object[0]);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return this.entity.getPassengers().isEmpty();
    }

    @Override
    public int getEntityId() {
        return this.entity.getEntityId();
    }

    @Override
    public void addProperty(String id, Object value) {
        this.properties.putIfAbsent(id, value);
    }

    @Override
    public void addProperty(String id, Object value, boolean force) {
        if (force) {
            this.properties.put(id, value);
        } else {
            this.properties.putIfAbsent(id, value);
        }
    }

    @Override
    public Optional<Object> getProperty(String id) {
        return Optional.ofNullable(this.properties.get(id));
    }

    @Override
    public <T> Optional<T> getProperty(String id, Class<T> expected) {
        Optional<Object> optional = Optional.ofNullable(this.properties.get(id));
        if (!optional.isPresent() || !expected.isInstance(optional.get())) {
            return Optional.empty();
        }
        return optional.map(o -> o);
    }

    @Override
    public void removeProperty(String id) {
        this.properties.remove(id);
    }

    @Override
    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public boolean hasGravity() {
        return this.entity.hasGravity();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.entity.setGravity(gravity);
    }

    @Override
    public boolean isGlowing() {
        return this.entity.isGlowing();
    }

    @Override
    public void setGlowing(boolean glowing) {
        this.entity.setGlowing(glowing);
    }

    @Override
    public boolean isSilent() {
        return this.entity.isSilent();
    }

    @Override
    public void setSilent(boolean silent) {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            this.entity.setSilent(silent);
        }
    }

    @Override
    public boolean isInvisible() {
        Object handled = SpigotHandledUtils.getEntityHandle(this.entity);
        try {
            return (Boolean)handled.getClass().getMethod("isInvisible", new Class[0]).invoke(handled, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        Object handled = SpigotHandledUtils.getEntityHandle(this.entity);
        try {
            handled.getClass().getMethod("setInvisible", Boolean.TYPE).invoke(handled, invisible);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isInvincible() {
        return this.invincible || this.invincibleMillis > System.currentTimeMillis();
    }

    @Override
    public void setInvincible(boolean invincible) {
        this.invincibleMillis = 0L;
        this.invincible = invincible;
    }

    @Override
    public void setInvincibleMillis(int millis) {
        this.invincibleMillis = System.currentTimeMillis() + (long)millis;
        this.invincible = false;
    }

    @Override
    public int getAir() {
        try {
            Object handled = SpigotHandledUtils.getEntityHandle(this.entity);
            return (Integer)handled.getClass().getMethod("getAir", new Class[0]).invoke((Object)this.entity, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void setAir(int air) {
        try {
            Object handled = SpigotHandledUtils.getEntityHandle(this.entity);
            handled.getClass().getMethod("setAir", Integer.TYPE).invoke((Object)this.entity, air);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getFireTicks() {
        return this.entity.getFireTicks();
    }

    @Override
    public void setFireTicks(int fireTicks) {
        this.entity.setFireTicks(fireTicks);
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.getMaxFireTicks();
    }

    @Override
    public float getFallDistance() {
        return this.entity.getFallDistance();
    }

    @Override
    public void setFallDistance(float fallDistance) {
        this.entity.setFallDistance(fallDistance);
    }

    @Override
    public Vector3d getEntitySize() {
        if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
            return new Vector3d(this.entity.getWidth(), this.entity.getHeight(), this.entity.getWidth());
        }
        Object handled = SpigotHandledUtils.getEntityHandle(this.getHandled());
        Class<?> entityClass = NMSUtils.getNMSClass("Entity");
        try {
            float width = entityClass.getField("width").getFloat(handled);
            float length = entityClass.getField("length").getFloat(handled);
            return new Vector3d(width, length, width);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An exception has occurred while WetSponge was getting the size of an Entity!");
            return new Vector3d();
        }
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompound(WSNBTTagCompound nbtTagCompound) {
        Object handled = SpigotHandledUtils.getHandle(this.entity);
        try {
            ReflectionUtils.invokeMethod(handled, WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "save" : "e", nbtTagCompound.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was saving an Entity on a NBTTagCompound!");
        }
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompoundAtomically(WSNBTTagCompound nbtTagCompound) {
        Object handled = SpigotHandledUtils.getHandle(this.entity);
        try {
            ReflectionUtils.invokeMethod(handled, "c", nbtTagCompound.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was saving an Entity on a NBTTagCompound!");
        }
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompoundOptional(WSNBTTagCompound nbtTagCompound) {
        Object handled = SpigotHandledUtils.getHandle(this.entity);
        try {
            ReflectionUtils.invokeMethod(handled, "d", nbtTagCompound.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was saving an Entity on a NBTTagCompound!");
        }
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound readFromNBTTagCompound(WSNBTTagCompound nbtTagCompound) {
        Object handled = SpigotHandledUtils.getHandle(this.entity);
        try {
            ReflectionUtils.invokeMethod(handled, "f", nbtTagCompound.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was saving an Entity on a NBTTagCompound!");
        }
        return nbtTagCompound;
    }

    @Override
    public void remove() {
        this.entity.remove();
    }

    public Entity getHandled() {
        return this.entity;
    }

    @Override
    public WSTranslation getTranslation() {
        throw new IllegalAccessError("Not supported by Spigot");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotEntity that = (SpigotEntity)o;
        return this.entity.equals(that.entity);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }
}

