/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.effect.potion;

import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.util.Validate;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.potion.PotionEffectTypes;

public class SpongePotionEffect
implements WSPotionEffect {
    private PotionEffect potionEffect;
    private EnumPotionEffectType type;

    public SpongePotionEffect(EnumPotionEffectType type, int duration, int amplifier, boolean ambient, boolean showParticles) {
        Validate.notNull((Object)type, "Type cannot be null!");
        this.potionEffect = PotionEffect.builder().potionType(Sponge.getRegistry().getType(PotionEffectType.class, type.name()).orElse(PotionEffectTypes.SPEED)).duration(duration).amplifier(amplifier).ambience(ambient).particles(showParticles).build();
        this.type = type;
    }

    public SpongePotionEffect(PotionEffect potionEffect) {
        Validate.notNull(potionEffect, "Potion effect cannot be null!");
        this.potionEffect = potionEffect;
        this.type = EnumPotionEffectType.getById(potionEffect.getType().getId()).orElseThrow(NullPointerException::new);
    }

    @Override
    public EnumPotionEffectType getType() {
        return this.type;
    }

    @Override
    public int getDuration() {
        return this.potionEffect.getDuration();
    }

    @Override
    public int getAmplifier() {
        return this.potionEffect.getAmplifier();
    }

    @Override
    public boolean isAmbient() {
        return this.potionEffect.isAmbient();
    }

    @Override
    public boolean getShowParticles() {
        return this.potionEffect.getShowParticles();
    }

    public PotionEffect getHandled() {
        return this.potionEffect;
    }

    public static class Builder
    implements WSPotionEffect.Builder {
        private EnumPotionEffectType type;
        private int duration;
        private int amplifier;
        private boolean ambient;
        private boolean showParticles;

        @Override
        public EnumPotionEffectType type() {
            return this.type;
        }

        @Override
        public WSPotionEffect.Builder type(EnumPotionEffectType type) {
            this.type = type;
            return this;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public WSPotionEffect.Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public WSPotionEffect.Builder amplifier(int amplifier) {
            this.amplifier = amplifier;
            return this;
        }

        @Override
        public boolean ambient() {
            return this.ambient;
        }

        @Override
        public WSPotionEffect.Builder ambient(boolean ambient) {
            this.ambient = ambient;
            return this;
        }

        @Override
        public boolean showParticles() {
            return this.showParticles;
        }

        @Override
        public WSPotionEffect.Builder showParticles(boolean showParticles) {
            this.showParticles = showParticles;
            return this;
        }

        @Override
        public WSPotionEffect build() {
            return new SpongePotionEffect(this.type, this.duration, this.amplifier, this.ambient, this.showParticles);
        }
    }
}

