/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.effect.potion;

import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.util.Validate;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Spigot13PotionEffect
implements WSPotionEffect {
    private PotionEffect potionEffect;
    private EnumPotionEffectType type;

    public Spigot13PotionEffect(EnumPotionEffectType type, int duration, int amplifier, boolean ambient, boolean showParticles) {
        Validate.notNull((Object)type, "Type cannot be null!");
        this.potionEffect = new PotionEffect(PotionEffectType.getById((int)type.getValue()), duration, amplifier, ambient, showParticles);
        this.type = type;
    }

    public Spigot13PotionEffect(PotionEffect potionEffect) {
        Validate.notNull(potionEffect, "Potion effect cannot be null!");
        this.potionEffect = potionEffect;
        this.type = EnumPotionEffectType.getByValue(potionEffect.getType().getId()).orElse(EnumPotionEffectType.SPEED);
    }

    @Override
    public EnumPotionEffectType getType() {
        return this.type;
    }

    @Override
    public int getDuration() {
        return this.potionEffect.getDuration();
    }

    @Override
    public int getAmplifier() {
        return this.potionEffect.getAmplifier();
    }

    @Override
    public boolean isAmbient() {
        return this.potionEffect.isAmbient();
    }

    @Override
    public boolean getShowParticles() {
        return this.potionEffect.hasParticles();
    }

    public PotionEffect getHandled() {
        return this.potionEffect;
    }

    public static class Builder
    implements WSPotionEffect.Builder {
        private EnumPotionEffectType type;
        private int duration;
        private int amplifier;
        private boolean ambient;
        private boolean showParticles;

        @Override
        public EnumPotionEffectType type() {
            return this.type;
        }

        @Override
        public WSPotionEffect.Builder type(EnumPotionEffectType type) {
            this.type = type;
            return this;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public WSPotionEffect.Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public WSPotionEffect.Builder amplifier(int amplifier) {
            this.amplifier = amplifier;
            return this;
        }

        @Override
        public boolean ambient() {
            return this.ambient;
        }

        @Override
        public WSPotionEffect.Builder ambient(boolean ambient) {
            this.ambient = ambient;
            return this;
        }

        @Override
        public boolean showParticles() {
            return this.showParticles;
        }

        @Override
        public WSPotionEffect.Builder showParticles(boolean showParticles) {
            this.showParticles = showParticles;
            return this;
        }

        @Override
        public WSPotionEffect build() {
            return new Spigot13PotionEffect(this.type, this.duration, this.amplifier, this.ambient, this.showParticles);
        }
    }
}

