/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.config;

import com.degoos.wetsponge.config.ConfigAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigSection {
    private ConfigAccessor parent;
    private String node;

    public ConfigSection(ConfigAccessor parent, String node) {
        this.parent = parent;
        this.node = node + ".";
    }

    public void set(String node, Object value) {
        this.parent.set(this.node + node, value);
    }

    public Object get(String node) {
        return this.parent.get(this.node + node);
    }

    public String getString(String node) {
        Object object = this.get(node);
        return object != null && object instanceof String ? (String)object : "";
    }

    public String getString(String node, String def) {
        Object object = this.get(node);
        return object != null && object instanceof String ? (String)object : def;
    }

    public byte getByte(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Byte ? (Byte)object : (byte)0;
    }

    public byte getByte(String node, byte def) {
        Object object = this.get(node);
        return object != null && object instanceof Byte ? (Byte)object : def;
    }

    public short getShort(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Short ? (Short)object : (short)0;
    }

    public short getShort(String node, short def) {
        Object object = this.get(node);
        return object != null && object instanceof Short ? (Short)object : def;
    }

    public int getInt(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Integer ? (Integer)object : 0;
    }

    public int getInt(String node, int def) {
        Object object = this.get(node);
        return object != null && object instanceof Integer ? (Integer)object : def;
    }

    public long getLong(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Long ? (Long)object : 0L;
    }

    public long getLong(String node, long def) {
        Object object = this.get(node);
        return object != null && object instanceof Long ? (Long)object : def;
    }

    public float getFloat(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Float ? ((Float)object).floatValue() : 0.0f;
    }

    public float getFloat(String node, float def) {
        Object object = this.get(node);
        return object != null && object instanceof Float ? ((Float)object).floatValue() : def;
    }

    public double getDouble(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Double ? (Double)object : 0.0;
    }

    public double getDouble(String node, double def) {
        Object object = this.get(node);
        return object != null && object instanceof Double ? (Double)object : def;
    }

    public boolean getBoolean(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Boolean ? (Boolean)object : false;
    }

    public boolean getBoolean(String node, boolean def) {
        Object object = this.get(node);
        return object != null && object instanceof Boolean ? (Boolean)object : def;
    }

    public List<?> getList(String node) {
        Object val = this.get(node);
        return val != null && val instanceof List ? (List)val : null;
    }

    public List<?> getList(String node, List<?> def) {
        List<?> val = this.get(node);
        return val instanceof List ? val : def;
    }

    public List<String> getStringList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<?> var4 = list.iterator();
        while (var4.hasNext()) {
            Object object = var4.next();
            if (!(object instanceof String) && !this.isPrimitiveWrapper(object)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }

    public List<String> getStringList(String node, List<String> def) {
        List<String> list = this.getStringList(node);
        return list == null || list.isEmpty() ? def : list;
    }

    private boolean isPrimitiveWrapper(Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }

    public Set<String> getKeys() {
        return this.parent.getKeys().stream().filter(key -> key.startsWith(this.node)).map(key -> key.replaceFirst(this.node, "")).collect(Collectors.toSet());
    }

    public Set<String> getKeys(boolean deep) {
        if (deep) {
            return this.getKeys();
        }
        return this.getKeys().stream().map(string -> string.replace(".", "/").split("/")[0]).collect(Collectors.toSet());
    }

    public boolean contains(String node) {
        return this.get(node) != null;
    }

    public ConfigSection getSection(String node) {
        return new ConfigSection(this.parent, this.node + node);
    }
}

