/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.command.wetspongecommand.plugin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.command.ramified.WSRamifiedCommand;
import com.degoos.wetsponge.command.ramified.WSSubcommand;
import com.degoos.wetsponge.command.wetspongecommand.plugin.WetSpongeSubcommandPluginLoad;
import com.degoos.wetsponge.command.wetspongecommand.plugin.WetSpongeSubcommandPluginUnload;
import com.degoos.wetsponge.config.WetSpongeMessages;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.plugin.WSPluginManager;
import com.degoos.wetsponge.text.WSText;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class WetSpongeSubcommandPluginReload
extends WSSubcommand {
    private WSSubcommand notFoundSubcommand;
    private Map<String, Set<String>> dependencies;

    public WetSpongeSubcommandPluginReload(WSRamifiedCommand command, WSSubcommand notFoundSubcommand) {
        super("reload", command);
        this.notFoundSubcommand = notFoundSubcommand;
        this.dependencies = new HashMap<String, Set<String>>();
    }

    @Override
    public void executeCommand(WSCommandSource commandSource, String command, String[] arguments, String[] remainingArguments) {
        if (remainingArguments.length == 0) {
            this.notFoundSubcommand.executeCommand(commandSource, command, arguments, remainingArguments);
            return;
        }
        Optional<WSPlugin> optional = WSPluginManager.getInstance().getPlugin(remainingArguments[0]);
        if (!optional.isPresent()) {
            commandSource.sendMessage(WetSpongeMessages.getMessage("command.plugin.common.notFound", new Object[0]).orElse(WSText.empty()));
            return;
        }
        WSPlugin plugin = optional.get();
        String id = plugin.getId();
        this.reloadPluginPhase1(plugin);
        WetSpongeSubcommandPluginUnload.unloadPlugin(commandSource, plugin);
        this.reloadPluginPhase2(commandSource, id);
    }

    @Override
    public List<String> sendTab(WSCommandSource commandSource, String command, String[] arguments, String[] remainingArguments) {
        return WetSponge.getPluginManager().getPluginFiles().keySet().stream().filter(arg -> arg.toLowerCase().startsWith(remainingArguments[0].toLowerCase())).collect(Collectors.toList());
    }

    public void reloadPluginPhase1(WSPlugin plugin) {
        List<WSPlugin> dependencies = WSPluginManager.getInstance().getPlugins().stream().filter(target -> target.isDependency(plugin)).collect(Collectors.toList());
        Set names = dependencies.stream().map(WSPlugin::getId).collect(Collectors.toSet());
        this.dependencies.put(plugin.getId(), names);
        dependencies.forEach(this::reloadPluginPhase1);
    }

    public void reloadPluginPhase2(WSCommandSource source, String name) {
        Set<String> dependencies = this.dependencies.get(name);
        WetSpongeSubcommandPluginLoad.loadPlugin(source, name);
        dependencies.forEach(target -> this.reloadPluginPhase2(source, (String)target));
    }
}

