/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.command;

import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeCommandSource
implements WSCommandSource {
    private CommandSource source;

    public SpongeCommandSource(CommandSource sender) {
        this.source = sender;
    }

    @Override
    public String getName() {
        return this.source.getName();
    }

    @Override
    public boolean hasPermission(String name) {
        return this.source.hasPermission(name);
    }

    @Override
    public Set<String> getPermissions() {
        HashSet<String> set = new HashSet<String>();
        this.source.getSubjectData().getAllPermissions().values().forEach(target -> target.entrySet().stream().filter(Map.Entry::getValue).forEach(entry -> set.add((String)entry.getKey())));
        return set;
    }

    @Override
    public void sendMessage(String message) {
        this.getHandled().sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(message));
    }

    @Override
    public void sendMessage(WSText text) {
        this.getHandled().sendMessage(((SpongeText)text).getHandled());
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessages(WSText ... texts) {
        for (WSText text : texts) {
            this.sendMessage(text);
        }
    }

    @Override
    public void performCommand(String command) {
        Sponge.getGame().getCommandManager().process(this.getHandled(), command);
    }

    public CommandSource getHandled() {
        return this.source;
    }
}

