/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bridge.nbt;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.exception.nbt.NBTParseException;
import com.degoos.wetsponge.nbt.Spigot13NBTTagByte;
import com.degoos.wetsponge.nbt.Spigot13NBTTagByteArray;
import com.degoos.wetsponge.nbt.Spigot13NBTTagCompound;
import com.degoos.wetsponge.nbt.Spigot13NBTTagDouble;
import com.degoos.wetsponge.nbt.Spigot13NBTTagEnd;
import com.degoos.wetsponge.nbt.Spigot13NBTTagFloat;
import com.degoos.wetsponge.nbt.Spigot13NBTTagInt;
import com.degoos.wetsponge.nbt.Spigot13NBTTagIntArray;
import com.degoos.wetsponge.nbt.Spigot13NBTTagList;
import com.degoos.wetsponge.nbt.Spigot13NBTTagLong;
import com.degoos.wetsponge.nbt.Spigot13NBTTagLongArray;
import com.degoos.wetsponge.nbt.Spigot13NBTTagShort;
import com.degoos.wetsponge.nbt.Spigot13NBTTagString;
import com.degoos.wetsponge.nbt.SpigotNBTTagByte;
import com.degoos.wetsponge.nbt.SpigotNBTTagByteArray;
import com.degoos.wetsponge.nbt.SpigotNBTTagCompound;
import com.degoos.wetsponge.nbt.SpigotNBTTagDouble;
import com.degoos.wetsponge.nbt.SpigotNBTTagEnd;
import com.degoos.wetsponge.nbt.SpigotNBTTagFloat;
import com.degoos.wetsponge.nbt.SpigotNBTTagInt;
import com.degoos.wetsponge.nbt.SpigotNBTTagIntArray;
import com.degoos.wetsponge.nbt.SpigotNBTTagList;
import com.degoos.wetsponge.nbt.SpigotNBTTagLong;
import com.degoos.wetsponge.nbt.SpigotNBTTagLongArray;
import com.degoos.wetsponge.nbt.SpigotNBTTagShort;
import com.degoos.wetsponge.nbt.SpigotNBTTagString;
import com.degoos.wetsponge.nbt.SpongeNBTTagByte;
import com.degoos.wetsponge.nbt.SpongeNBTTagByteArray;
import com.degoos.wetsponge.nbt.SpongeNBTTagCompound;
import com.degoos.wetsponge.nbt.SpongeNBTTagDouble;
import com.degoos.wetsponge.nbt.SpongeNBTTagEnd;
import com.degoos.wetsponge.nbt.SpongeNBTTagFloat;
import com.degoos.wetsponge.nbt.SpongeNBTTagInt;
import com.degoos.wetsponge.nbt.SpongeNBTTagIntArray;
import com.degoos.wetsponge.nbt.SpongeNBTTagList;
import com.degoos.wetsponge.nbt.SpongeNBTTagLong;
import com.degoos.wetsponge.nbt.SpongeNBTTagLongArray;
import com.degoos.wetsponge.nbt.SpongeNBTTagShort;
import com.degoos.wetsponge.nbt.SpongeNBTTagString;
import com.degoos.wetsponge.nbt.WSNBTTagByte;
import com.degoos.wetsponge.nbt.WSNBTTagByteArray;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagDouble;
import com.degoos.wetsponge.nbt.WSNBTTagEnd;
import com.degoos.wetsponge.nbt.WSNBTTagFloat;
import com.degoos.wetsponge.nbt.WSNBTTagInt;
import com.degoos.wetsponge.nbt.WSNBTTagIntArray;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.nbt.WSNBTTagLong;
import com.degoos.wetsponge.nbt.WSNBTTagLongArray;
import com.degoos.wetsponge.nbt.WSNBTTagShort;
import com.degoos.wetsponge.nbt.WSNBTTagString;
import com.degoos.wetsponge.util.InternalLogger;

public class BridgeNBT {
    public static WSNBTTagByte ofByte(byte b) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagByte(b);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagByte(b);
                    }
                    return new Spigot13NBTTagByte(b);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagByteArray ofByteArray(byte[] bytes) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagByteArray(bytes);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagByteArray(bytes);
                    }
                    return new Spigot13NBTTagByteArray(bytes);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagCompound newCompound() {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagCompound();
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagCompound();
                    }
                    return new Spigot13NBTTagCompound();
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagCompound ofCompound(String string) throws NBTParseException {
        try {
            switch (WetSponge.getServerType()) {
                case SPONGE: {
                    return new SpongeNBTTagCompound(string);
                }
                case SPIGOT: 
                case PAPER_SPIGOT: {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagCompound(string);
                    }
                    return new Spigot13NBTTagCompound(string);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new NBTParseException("An error has occurred while WetSponge was parsing a NBTTagCompound!", e);
        }
    }

    public static WSNBTTagDouble ofDouble(double d) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagDouble(d);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagDouble(d);
                    }
                    return new Spigot13NBTTagDouble(d);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagEnd newEnd() {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagEnd();
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return new SpigotNBTTagEnd();
                }
                return new Spigot13NBTTagEnd();
            }
        }
        return null;
    }

    public static WSNBTTagFloat ofFloat(float f) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagFloat(f);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagFloat(f);
                    }
                    return new Spigot13NBTTagFloat(f);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagInt ofInt(int i) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagInt(i);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagInt(i);
                    }
                    return new Spigot13NBTTagInt(i);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagIntArray ofIntArray(int[] ints) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagIntArray(ints);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagIntArray(ints);
                    }
                    return new Spigot13NBTTagIntArray(ints);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagList newList() {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagList();
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagList();
                    }
                    return new Spigot13NBTTagList();
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagLong ofLong(long l) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagLong(l);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagLong(l);
                    }
                    return new Spigot13NBTTagLong(l);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagLongArray ofLongArray(long[] longs) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagLongArray(longs);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagLongArray(longs);
                    }
                    return new Spigot13NBTTagLongArray(longs);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagShort ofShort(short s2) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagShort(s2);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagShort(s2);
                    }
                    return new Spigot13NBTTagShort(s2);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }

    public static WSNBTTagString ofString(String string) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeNBTTagString(string);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotNBTTagString(string);
                    }
                    return new Spigot13NBTTagString(string);
                }
                catch (Exception e) {
                    InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was creating a new NBTTag!");
                    return null;
                }
            }
        }
        return null;
    }
}

