/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bridge.item;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.item.Spigot13ItemStack;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.material.WSMaterial;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;

public class BridgeItemStack {
    public static WSItemStack of(WSMaterial material) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return SpongeItemStack.of(material);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return SpigotItemStack.of(material);
                }
                return Spigot13ItemStack.of(material);
            }
        }
        return null;
    }

    public static WSItemStack ofSerializedNBTTag(String nbt) throws Exception {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeItemStack(nbt);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return new SpigotItemStack(nbt);
                }
                return new Spigot13ItemStack(nbt);
            }
        }
        return null;
    }

    public static WSItemStack ofNBTTagCompound(WSNBTTagCompound nbtTagCompound) throws Exception {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return new SpongeItemStack(nbtTagCompound);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return new SpigotItemStack(nbtTagCompound);
                }
                return new Spigot13ItemStack(nbtTagCompound);
            }
        }
        return null;
    }

    public static WSItemStack createSkull(String format) {
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return SpongeItemStack.fromFormat(format);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return SpigotItemStack.fromFormat(format);
                }
                return Spigot13ItemStack.fromFormat(format);
            }
        }
        return null;
    }
}

