/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block.tileentity;

import com.degoos.wetsponge.block.SpigotBlock;
import com.degoos.wetsponge.block.tileentity.SpigotTileEntityNameableInventory;
import com.degoos.wetsponge.block.tileentity.WSTileEntityDispenser;
import com.degoos.wetsponge.entity.projectile.WSProjectile;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import org.bukkit.block.Dispenser;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class SpigotTileEntityDispenser
extends SpigotTileEntityNameableInventory
implements WSTileEntityDispenser {
    public SpigotTileEntityDispenser(SpigotBlock block) {
        super(block);
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile) {
        return this.launchProjectile(projectile, new Vector3d(0.0f, 0.0f, 0.0f));
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile, Vector3d velocity) {
        EnumEntityType type = EnumEntityType.getByClass(projectile).orElse(EnumEntityType.UNKNOWN);
        if (type == EnumEntityType.UNKNOWN) {
            return Optional.empty();
        }
        try {
            Class<? extends Entity> spigotClass = SpigotEntityParser.getEntityData(type).getEntityClass();
            return Optional.ofNullable(this.getHandled().getBlockProjectileSource().launchProjectile(spigotClass, new Vector(velocity.getX(), velocity.getY(), velocity.getZ()))).map(entity -> (WSProjectile)SpigotEntityParser.getWSEntity((Entity)entity));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public Dispenser getHandled() {
        return (Dispenser)super.getHandled();
    }
}

