/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block;

import com.degoos.wetsponge.block.SpongeBlock;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.WSBlockState;
import com.degoos.wetsponge.material.SpongeMaterial;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.value.ValueContainer;

public class SpongeBlockState
implements WSBlockState {
    private WSLocation location;
    private WSBlockType blockType;
    private SpongeBlock block;

    public SpongeBlockState(SpongeBlock block) {
        this.location = block.getLocation();
        this.block = block;
        this.refresh();
    }

    @Override
    public WSLocation getLocation() {
        return this.location.clone();
    }

    @Override
    public WSWorld getWorld() {
        return this.location.getWorld();
    }

    @Override
    public WSBlock getBlock() {
        return this.block;
    }

    @Override
    public WSBlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public SpongeBlockState setBlockType(WSBlockType blockType) {
        this.blockType = blockType;
        return this;
    }

    @Override
    public void update() {
        this.update(true);
    }

    @Override
    public void update(boolean applyPhysics) {
        this.block.getHandled().setBlock(((SpongeBlockType)this.blockType).writeBlockState(((BlockType)Sponge.getRegistry().getType(BlockType.class, this.blockType.getStringId()).get()).getDefaultState()));
        this.getWorld().getPlayers().forEach(player -> player.sendPacket(WSSPacketBlockChange.of(this.blockType, this.location.toVector3i())));
    }

    @Override
    public void refresh() {
        this.blockType = WSBlockTypes.getById(this.block.getStringId()).orElse(WSBlockTypes.AIR.getDefaultState());
        ((SpongeMaterial)((Object)this.blockType)).readContainer((ValueContainer<?>)this.block.getHandled().getBlock());
    }
}

