/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block;

import com.degoos.wetsponge.block.SpigotBlock;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.WSBlockState;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class SpigotBlockState
implements WSBlockState {
    private WSLocation location;
    private WSBlockType blockType;
    private SpigotBlock block;

    public SpigotBlockState(SpigotBlock block) {
        this.location = block.getLocation();
        this.block = block;
        this.refresh();
    }

    @Override
    public WSLocation getLocation() {
        return this.location;
    }

    @Override
    public WSWorld getWorld() {
        return this.location.getWorld();
    }

    @Override
    public WSBlock getBlock() {
        return this.block;
    }

    @Override
    public WSBlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public SpigotBlockState setBlockType(WSBlockType blockType) {
        this.blockType = blockType;
        return this;
    }

    @Override
    public void update() {
        this.update(true);
    }

    @Override
    public void update(boolean applyPhysics) {
        Block spigotBlock = this.block.getHandled();
        spigotBlock.setType(Material.getMaterial((int)this.blockType.getNumericalId()));
        spigotBlock.setData(((SpigotBlockType)this.blockType).toMaterialData().getData());
        BlockState state = spigotBlock.getState();
        state.update(true, applyPhysics);
    }

    @Override
    public void refresh() {
        this.blockType = this.block.getBlockType();
    }
}

