/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bar;

import com.degoos.wetsponge.bar.WSBossBar;
import com.degoos.wetsponge.entity.living.player.Spigot13Player;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBossBarColor;
import com.degoos.wetsponge.enums.EnumBossBarOverlay;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.text.WSText;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;

public class Spigot13BossBar
implements WSBossBar {
    private BossBar bossBar;

    public Spigot13BossBar(BossBar bossBar) {
        this.bossBar = bossBar;
    }

    @Override
    public Spigot13BossBar addPlayer(WSPlayer player) {
        this.bossBar.addPlayer(((Spigot13Player)player).getHandled());
        return this;
    }

    @Override
    public Spigot13BossBar removePlayer(WSPlayer player) {
        this.bossBar.removePlayer(((Spigot13Player)player).getHandled());
        return this;
    }

    @Override
    public Spigot13BossBar clearPlayers() {
        this.bossBar.getPlayers().forEach(arg_0 -> ((BossBar)this.bossBar).removePlayer(arg_0));
        return this;
    }

    @Override
    public Set<WSPlayer> getPlayers() {
        return this.bossBar.getPlayers().stream().map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId())).collect(Collectors.toSet());
    }

    @Override
    public EnumBossBarColor getColor() {
        return EnumBossBarColor.getByName(this.bossBar.getColor().name()).orElse(EnumBossBarColor.PURPLE);
    }

    @Override
    public Spigot13BossBar setColor(EnumBossBarColor color) {
        this.bossBar.setColor(BarColor.valueOf((String)color.name()));
        return this;
    }

    @Override
    public EnumBossBarOverlay getOverlay() {
        return EnumBossBarOverlay.getBySpigotName(this.bossBar.getStyle().name()).orElse(EnumBossBarOverlay.PROGRESS);
    }

    @Override
    public Spigot13BossBar setOverlay(EnumBossBarOverlay overlay) {
        this.bossBar.setStyle(BarStyle.valueOf((String)overlay.getSpigotName()));
        return this;
    }

    @Override
    public float getPercent() {
        return (float)this.bossBar.getProgress();
    }

    @Override
    public Spigot13BossBar setPercent(float percent) {
        this.bossBar.setProgress((double)percent);
        return this;
    }

    @Override
    public boolean shouldCreateFog() {
        return this.bossBar.hasFlag(BarFlag.CREATE_FOG);
    }

    @Override
    public Spigot13BossBar setCreateFog(boolean createFog) {
        if (createFog) {
            this.bossBar.addFlag(BarFlag.CREATE_FOG);
        } else {
            this.bossBar.removeFlag(BarFlag.CREATE_FOG);
        }
        return this;
    }

    @Override
    public boolean shouldDarkenSky(boolean darkenSky) {
        return this.bossBar.hasFlag(BarFlag.DARKEN_SKY);
    }

    @Override
    public Spigot13BossBar setDarkenSky(boolean darkenSky) {
        if (darkenSky) {
            this.bossBar.addFlag(BarFlag.DARKEN_SKY);
        } else {
            this.bossBar.removeFlag(BarFlag.DARKEN_SKY);
        }
        return this;
    }

    @Override
    public boolean shouldPlayEndBossMusic() {
        return this.bossBar.hasFlag(BarFlag.PLAY_BOSS_MUSIC);
    }

    @Override
    public Spigot13BossBar setPlayEndBossMusic(boolean playEndBossMusic) {
        if (playEndBossMusic) {
            this.bossBar.addFlag(BarFlag.PLAY_BOSS_MUSIC);
        } else {
            this.bossBar.removeFlag(BarFlag.PLAY_BOSS_MUSIC);
        }
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.bossBar.isVisible();
    }

    @Override
    public Spigot13BossBar setVisible(boolean visible) {
        this.bossBar.setVisible(visible);
        return this;
    }

    @Override
    public WSText getName() {
        return WSText.getByFormattingText(this.bossBar.getTitle());
    }

    @Override
    public Spigot13BossBar setName(WSText name) {
        this.bossBar.setTitle(name.toFormattingText());
        return this;
    }

    public BossBar getHandled() {
        return this.bossBar;
    }

    public static class Builder
    implements WSBossBar.Builder {
        private EnumBossBarColor color = EnumBossBarColor.PURPLE;
        private EnumBossBarOverlay overlay = EnumBossBarOverlay.PROGRESS;
        private float percent = 1.0f;
        private boolean createFog = false;
        private boolean darkenSky = false;
        private boolean endBossMusic = false;
        private boolean visible = false;
        private WSText name = WSText.of("");

        @Override
        public Builder color(EnumBossBarColor color) {
            this.color = color;
            return this;
        }

        @Override
        public Builder overlay(EnumBossBarOverlay overlay) {
            this.overlay = overlay;
            return this;
        }

        @Override
        public Builder percent(float percent) {
            this.percent = percent;
            return this;
        }

        @Override
        public Builder createFog(boolean createFog) {
            this.createFog = createFog;
            return this;
        }

        @Override
        public Builder darkenSky(boolean darkenSky) {
            this.darkenSky = darkenSky;
            return this;
        }

        @Override
        public Builder playEndBossMusic(boolean endBossMusic) {
            this.endBossMusic = endBossMusic;
            return this;
        }

        @Override
        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        @Override
        public Builder name(WSText name) {
            this.name = name;
            return this;
        }

        @Override
        public WSBossBar build() {
            BossBar bar = Bukkit.createBossBar((String)this.name.toFormattingText(), (BarColor)BarColor.valueOf((String)this.color.name()), (BarStyle)BarStyle.valueOf((String)this.overlay.getSpigotName()), (BarFlag[])new BarFlag[0]);
            bar.setVisible(this.visible);
            bar.setProgress((double)this.percent);
            if (this.createFog) {
                bar.addFlag(BarFlag.CREATE_FOG);
            }
            if (this.darkenSky) {
                bar.addFlag(BarFlag.DARKEN_SKY);
            }
            if (this.endBossMusic) {
                bar.addFlag(BarFlag.PLAY_BOSS_MUSIC);
            }
            return new Spigot13BossBar(bar);
        }
    }
}

