/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.wetspongeutils;

import co.aikar.timings.TimingsManager;
import co.aikar.util.JSONUtil;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.common.SpongeImpl;

public class SpongeTimingsUtils {
    private static final Joiner CONFIG_PATH_JOINER = Joiner.on(".");

    public static JsonElement serializeConfigNode() {
        return SpongeTimingsUtils.serializeConfigNode((ConfigurationNode)SpongeImpl.getGlobalConfig().getRootNode());
    }

    public static JsonElement serializeConfigNode(ConfigurationNode node) {
        if (node.hasMapChildren()) {
            JsonObject object = new JsonObject();
            for (Map.Entry entry : node.getChildrenMap().entrySet()) {
                String fullPath = CONFIG_PATH_JOINER.join(((ConfigurationNode)entry.getValue()).getPath());
                if (fullPath.equals("sponge.sql") || TimingsManager.hiddenConfigs.contains(fullPath)) continue;
                object.add(entry.getKey().toString(), SpongeTimingsUtils.serializeConfigNode((ConfigurationNode)entry.getValue()));
            }
            return object;
        }
        if (node.hasListChildren()) {
            JsonArray array = new JsonArray();
            for (ConfigurationNode child : node.getChildrenList()) {
                array.add(SpongeTimingsUtils.serializeConfigNode(child));
            }
            return array;
        }
        return JSONUtil.toJsonElement((Object)node.getValue());
    }
}

