/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.wetspongeutils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JSONUtil {
    private JSONUtil() {
    }

    public static JSONPair pair(String key, Object obj) {
        return new JSONPair(key, obj);
    }

    public static JSONPair pair(long key, Object obj) {
        return new JSONPair(String.valueOf(key), obj);
    }

    public static Map createObject(JSONPair ... data) {
        return JSONUtil.appendObjectData(new LinkedHashMap(), data);
    }

    public static Map appendObjectData(Map parent, JSONPair ... data) {
        for (JSONPair JSONPair2 : data) {
            parent.put(JSONPair2.key, JSONPair2.val);
        }
        return parent;
    }

    public static List toArray(Object ... data) {
        return Lists.newArrayList(data);
    }

    public static <E> List toArrayMapper(E[] collection, Function<E, Object> mapper) {
        return JSONUtil.toArrayMapper(Lists.newArrayList(collection), mapper);
    }

    public static <E> List toArrayMapper(Iterable<E> collection, Function<E, Object> mapper) {
        ArrayList<Object> array = Lists.newArrayList();
        for (E e : collection) {
            Object object = mapper.apply(e);
            if (object == null) continue;
            array.add(object);
        }
        return array;
    }

    public static <E> Map toObjectMapper(E[] collection, Function<E, JSONPair> mapper) {
        return JSONUtil.toObjectMapper(Lists.newArrayList(collection), mapper);
    }

    public static <E> Map toObjectMapper(Iterable<E> collection, Function<E, JSONPair> mapper) {
        LinkedHashMap<String, Object> object = Maps.newLinkedHashMap();
        for (E e : collection) {
            JSONPair JSONPair2 = mapper.apply(e);
            if (JSONPair2 == null) continue;
            object.put(JSONPair2.key, JSONPair2.val);
        }
        return object;
    }

    public static JsonObjectBuilder objectBuilder() {
        return new JsonObjectBuilder();
    }

    public static <E> JsonArray mapArray(E[] elements, java.util.function.Function<E, Object> function) {
        return JSONUtil.mapArray(Lists.newArrayList(elements), function);
    }

    public static <E> JsonArray mapArray(Iterable<E> elements, java.util.function.Function<E, Object> function) {
        ArrayList<Object> list = Lists.newArrayList();
        for (E element : elements) {
            Object transformed = function.apply(element);
            if (transformed == null) continue;
            list.add(transformed);
        }
        return new GsonBuilder().serializeNulls().create().toJsonTree(list).getAsJsonArray();
    }

    public static <E> JsonObject mapArrayToObject(E[] array, java.util.function.Function<E, JsonObject> function) {
        return JSONUtil.mapArrayToObject(Lists.newArrayList(array), function);
    }

    public static <E> JsonObject mapArrayToObject(Iterable<E> iterable, java.util.function.Function<E, JsonObject> function) {
        JsonObjectBuilder builder = JSONUtil.objectBuilder();
        for (E element : iterable) {
            JsonObject obj = function.apply(element);
            if (obj == null) continue;
            for (Map.Entry entry : obj.entrySet()) {
                builder.add((String)entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    public static String toString(JsonElement element) {
        return new GsonBuilder().serializeNulls().create().toJson(element);
    }

    public static JsonElement toJsonElement(Object value) {
        return new GsonBuilder().serializeNulls().create().toJsonTree(value);
    }

    public static JsonObject singleObjectPair(String key, Object value) {
        return JSONUtil.objectBuilder().add(key, value).build();
    }

    public static JsonObject singleObjectPair(int key, Object value) {
        return JSONUtil.objectBuilder().add(key, value).build();
    }

    public static JsonArray arrayOf(Object ... elements) {
        return new GsonBuilder().serializeNulls().create().toJsonTree((Object)elements).getAsJsonArray();
    }

    public static class JsonObjectBuilder {
        private final Map<String, Object> elements = Maps.newHashMap();

        public JsonObjectBuilder add(int key, Object value) {
            return this.add(String.valueOf(key), value);
        }

        public JsonObjectBuilder add(String key, Object value) {
            if (value instanceof JsonObjectBuilder) {
                value = ((JsonObjectBuilder)value).build();
            }
            this.elements.put(key, value);
            return this;
        }

        public JsonObject build() {
            return new GsonBuilder().serializeNulls().create().toJsonTree(this.elements).getAsJsonObject();
        }
    }

    public static class JSONPair {
        final String key;
        final Object val;

        JSONPair(String key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

