/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.wetspongetimings;

import com.degoos.wetsponge.event.WSEvent;
import com.degoos.wetsponge.event.WSListener;
import com.degoos.wetsponge.plugin.WSPlugin;
import java.lang.reflect.Method;

public class TimedEventListener {
    private final Method method;
    private final Class<? extends WSEvent> eventClass;
    private final Object listener;
    private final WSPlugin plugin;
    private final boolean ignoreCancelled;

    public TimedEventListener(Object listener, Method method, WSPlugin plugin, Class<? extends WSEvent> eventClass) {
        this.method = method;
        this.listener = listener;
        this.eventClass = eventClass;
        this.plugin = plugin;
        this.ignoreCancelled = method.getAnnotation(WSListener.class).ignoreCancelled();
        String id = method.getClass().getSimpleName() + " -> " + method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<? extends WSEvent> getEventClass() {
        return this.eventClass;
    }

    public Object getListener() {
        return this.listener;
    }

    public WSPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isIgnoreCancelled() {
        return this.ignoreCancelled;
    }

    public void execute(WSEvent event) throws Exception {
        if (!this.eventClass.isInstance(event)) {
            return;
        }
        this.method.invoke(this.listener, event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimedEventListener that = (TimedEventListener)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.listener.equals(that.listener);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.listener.hashCode();
        return result;
    }
}

