/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.markdown.converter;

import com.deepoove.poi.data.Cells;
import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.Documents;
import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.NumberingItemRenderData;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.Rows;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.Tables;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.Texts;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.plugin.highlight.HighlightRenderData;
import com.deepoove.poi.plugin.highlight.converter.HighlightToDocumentRenderDataConverter;
import com.deepoove.poi.plugin.markdown.MarkdownStyle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentVisitor
extends AbstractVisitor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DocumentVisitor.class);
    private static HighlightToDocumentRenderDataConverter highlightConverter = new HighlightToDocumentRenderDataConverter();
    private static List<NumberingFormat.Builder> multiLevelFormat = Arrays.asList(NumberingFormat.DECIMAL_PARENTHESES_BUILDER, NumberingFormat.LOWER_LETTER_BUILDER, NumberingFormat.UPPER_LETTER_BUILDER, NumberingFormat.UPPER_ROMAN_BUILDER);
    private Documents.DocumentBuilder of = Documents.of();
    private MarkdownStyle style;
    private int[] headerNumberArray = new int[10];
    private Iterator<NumberingFormat.Builder> iterator;

    public DocumentVisitor(MarkdownStyle style) {
        this.style = null == style ? new MarkdownStyle() : style;
    }

    public void visit(Heading heading) {
        DocumentRenderData renderData;
        int level = heading.getLevel();
        this.resetHeaderNumberArray(level);
        Paragraphs.ParagraphBuilder paraOf = Paragraphs.of().styleId(String.valueOf(level)).left().allowWordBreak();
        if (this.style.isShowHeaderNumber()) {
            paraOf.addText(this.getHeaderNumber(level));
        }
        if (!(renderData = this.parseNode((Node)heading)).getContents().isEmpty()) {
            ParagraphRenderData headerParagraph = (ParagraphRenderData)renderData.getContents().get(0);
            paraOf.addParagraph(headerParagraph);
            paraOf.addText(Texts.of((String)"").bookmark(this.evalText(headerParagraph)).create());
        }
        this.of.addParagraph(paraOf.create());
    }

    public void visit(Paragraph paragraph) {
        this.of.addDocument(this.parseNode((Node)paragraph));
    }

    private DocumentRenderData parseNode(Node block) {
        if (block instanceof FencedCodeBlock) {
            return this.parseFencedCodeBlock((FencedCodeBlock)block);
        }
        if (block instanceof IndentedCodeBlock) {
            return this.parseIndentedCodeBlock((IndentedCodeBlock)block);
        }
        Documents.DocumentBuilder docOf = Documents.of();
        Paragraphs.ParagraphBuilder paraOf = Paragraphs.of().left();
        for (Node node = block.getFirstChild(); node != null; node = node.getNext()) {
            if (node instanceof Text) {
                paraOf.addText(((Text)node).getLiteral()).create();
                continue;
            }
            if (node instanceof StrongEmphasis || node instanceof Emphasis) {
                DocumentRenderData ret = this.parseNode(node);
                for (RenderData r : ret.getContents()) {
                    paraOf.addParagraph((ParagraphRenderData)r);
                }
                continue;
            }
            if (node instanceof Code) {
                Texts.TextBuilder ofCode = Texts.of((String)((Code)node).getLiteral()).style(this.style.getInlineCodeStyle());
                paraOf.addText(ofCode.create()).create();
                continue;
            }
            if (node instanceof SoftLineBreak || node instanceof HardLineBreak) {
                docOf.addParagraph(paraOf.create());
                paraOf = Paragraphs.of().left();
                continue;
            }
            if (node instanceof HtmlInline) {
                paraOf.addText(((HtmlInline)node).getLiteral()).create();
                continue;
            }
            if (node instanceof HtmlBlock) {
                paraOf.addText(((HtmlBlock)node).getLiteral()).create();
                continue;
            }
            if (node instanceof Image) {
                paraOf.addPicture(this.parsePicture((Image)node));
                continue;
            }
            if (node instanceof Link) {
                String destination = ((Link)node).getDestination();
                Node textLink = node.getFirstChild();
                if (textLink instanceof Text) {
                    paraOf.addText(Texts.of((String)((Text)textLink).getLiteral()).link(destination).create()).create();
                    continue;
                }
                if (!(textLink instanceof Image)) continue;
                paraOf.addPicture(this.parsePicture((Image)textLink));
                continue;
            }
            LOGGER.warn("Current not support visit node: " + node);
        }
        return docOf.addParagraph(paraOf.create()).create();
    }

    private PictureRenderData parsePicture(Image image) {
        String uri = image.getDestination();
        if (!uri.startsWith("http")) {
            uri = this.style.getImagesDir() + uri;
        }
        return Pictures.of((String)uri).altMeta(image.getTitle()).fitSize().create();
    }

    private DocumentRenderData parseIndentedCodeBlock(IndentedCodeBlock indentedCodeBlock) {
        return this.parseCode(indentedCodeBlock.getLiteral(), "java");
    }

    private DocumentRenderData parseFencedCodeBlock(FencedCodeBlock fencedCodeBlock) {
        return this.parseCode(fencedCodeBlock.getLiteral(), fencedCodeBlock.getInfo());
    }

    private DocumentRenderData parseCode(String code, String language) {
        HighlightRenderData highlight = new HighlightRenderData();
        highlight.setCode(code.endsWith("\n") ? code.substring(0, code.length() - 1) : code);
        highlight.setLanguage(language);
        highlight.setStyle(this.style.getHighlightStyle());
        try {
            DocumentRenderData apply = highlightConverter.convert(highlight);
            for (RenderData doc : apply.getContents()) {
                if (!(doc instanceof ParagraphRenderData)) continue;
                ParagraphStyle paragraphStyle = ((ParagraphRenderData)doc).getParagraphStyle();
                if (null == paragraphStyle) {
                    paragraphStyle = new ParagraphStyle();
                    ((ParagraphRenderData)doc).setParagraphStyle(paragraphStyle);
                }
                paragraphStyle.setSpacing(Double.valueOf(1.0));
            }
            return apply;
        }
        catch (Exception e) {
            throw new RenderException("Error Parse Code", e);
        }
    }

    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.of.addDocument(this.parseIndentedCodeBlock(indentedCodeBlock));
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.of.addDocument(this.parseFencedCodeBlock(fencedCodeBlock));
    }

    public void visit(OrderedList orderedList) {
        this.resetFormatIterator();
        this.of.addNumbering(this.parseList((ListBlock)orderedList, new NumberingRenderData(), 0));
    }

    public void visit(BulletList bulletList) {
        this.resetFormatIterator();
        this.of.addNumbering(this.parseList((ListBlock)bulletList, new NumberingRenderData(), 0));
    }

    private void resetFormatIterator() {
        this.iterator = multiLevelFormat.iterator();
    }

    private NumberingRenderData parseList(ListBlock listBlock, NumberingRenderData numberingRenderData, int index) {
        List formats = numberingRenderData.getFormats();
        if (listBlock instanceof BulletList) {
            formats.add(NumberingFormat.BULLET);
        } else if (null != this.iterator && this.iterator.hasNext()) {
            formats.add(this.iterator.next().build(index));
        } else {
            formats.add(NumberingFormat.DECIMAL_PARENTHESES_BUILDER.build(index));
        }
        List result = numberingRenderData.getItems();
        for (Node node = listBlock.getFirstChild(); null != node; node = node.getNext()) {
            if (!(node instanceof ListItem)) continue;
            boolean first = true;
            for (Node itemNode = node.getFirstChild(); null != itemNode; itemNode = itemNode.getNext()) {
                if (itemNode instanceof ListBlock) {
                    this.parseList((ListBlock)itemNode, numberingRenderData, index + 1);
                    continue;
                }
                DocumentRenderData ret = this.parseNode(itemNode);
                List contents = ret.getContents();
                for (int i = 0; i < contents.size(); ++i) {
                    RenderData content = (RenderData)contents.get(i);
                    ParagraphRenderData paragraph = (ParagraphRenderData)content;
                    if (first) {
                        result.add(new NumberingItemRenderData(index, paragraph));
                        first = false;
                        continue;
                    }
                    if (paragraph.getParagraphStyle() == null) {
                        paragraph.setParagraphStyle(new ParagraphStyle());
                    }
                    paragraph.getParagraphStyle().setIndentLeftChars(Double.valueOf((double)index * 1.8));
                    result.add(new NumberingItemRenderData(-1, paragraph));
                }
            }
        }
        return numberingRenderData;
    }

    public void visit(BlockQuote blockQuote) {
        boolean first = true;
        for (Node node = blockQuote.getFirstChild(); null != node; node = node.getNext()) {
            if (node instanceof BlockQuote) {
                this.visit((BlockQuote)node);
                continue;
            }
            DocumentRenderData ret = this.parseNode((Node)((Paragraph)node));
            List contents = ret.getContents();
            int size = contents.size();
            for (int i = 0; i < size; ++i) {
                RenderData content = (RenderData)contents.get(i);
                ParagraphRenderData paragraph = (ParagraphRenderData)content;
                paragraph.setParagraphStyle(this.style.getQuoteStyle());
                ParagraphStyle paragraphStyle = paragraph.getParagraphStyle();
                if (null == paragraphStyle) {
                    paragraphStyle = new ParagraphStyle();
                    paragraph.setParagraphStyle(paragraphStyle);
                }
                if (first) {
                    paragraphStyle.setSpacingBeforeLines(Double.valueOf(0.4));
                    first = false;
                }
                if (i == size - 1) {
                    paragraphStyle.setSpacingAfterLines(Double.valueOf(0.4));
                }
                this.of.addParagraph(paragraph);
            }
        }
    }

    public void visit(CustomBlock customBlock) {
        if (customBlock instanceof TableBlock) {
            this.visitTable((TableBlock)customBlock);
        } else {
            super.visit(customBlock);
        }
    }

    private void visitTable(TableBlock table) {
        this.of.addTable(this.parseTable(table));
    }

    private TableRenderData parseTable(TableBlock table) {
        Tables.TableBuilder tableOf = Tables.ofPercentWidth((String)"100%");
        tableOf.cellMargin((double)0.19f, (double)0.19f, (double)0.19f, (double)0.19f);
        for (Node headOrBody = table.getFirstChild(); null != headOrBody; headOrBody = headOrBody.getNext()) {
            boolean isTH = headOrBody instanceof TableHead;
            for (Node row = headOrBody.getFirstChild(); row != null; row = row.getNext()) {
                Rows.RowBuilder rowOf = Rows.of();
                if (isTH) {
                    rowOf.rowStyle(this.style.getTableHeaderStyle());
                }
                for (Node cell = row.getFirstChild(); null != cell; cell = cell.getNext()) {
                    Cells.CellBuilder cellOf = Cells.of();
                    DocumentRenderData ret = this.parseNode(cell);
                    if (ret.getContents().isEmpty()) {
                        rowOf.addCell(Cells.of((String)"").create());
                        continue;
                    }
                    for (RenderData r : ret.getContents()) {
                        cellOf.addParagraph((ParagraphRenderData)r);
                    }
                    rowOf.addCell(cellOf.create());
                }
                tableOf.addRow(rowOf.create());
            }
        }
        return tableOf.border(this.style.getTableBorderStyle()).create();
    }

    public void visit(Image image) {
    }

    public void visit(Text text) {
    }

    public void visit(ThematicBreak thematicBreak) {
    }

    public void visit(HtmlBlock node) {
        this.of.addParagraph(Paragraphs.of((String)node.getLiteral()).create());
    }

    protected void visitChildren(Node parent) {
        if (parent instanceof Document || parent instanceof Paragraph) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                node.accept((Visitor)this);
                node = next;
            }
        } else {
            LOGGER.warn("Current not support visit node: " + parent);
        }
    }

    public DocumentRenderData getResult() {
        return this.of.create();
    }

    private String evalText(ParagraphRenderData paragraph) {
        StringBuilder text = new StringBuilder();
        paragraph.getContents().stream().filter(r -> r instanceof TextRenderData).forEach(r -> text.append(((TextRenderData)r).getText()));
        return text.toString();
    }

    private void resetHeaderNumberArray(int level) {
        int n = level;
        this.headerNumberArray[n] = this.headerNumberArray[n] + 1;
        for (int i = level + 1; i < this.headerNumberArray.length; ++i) {
            this.headerNumberArray[i] = 0;
        }
    }

    private String getHeaderNumber(int level) {
        String str;
        if (level == 1) {
            return "";
        }
        String substring = str.substring(0, (level - 1) * 2 >= (str = StringUtils.join((int[])Arrays.copyOfRange(this.headerNumberArray, 2, this.headerNumberArray.length), (char)'.')).length() ? str.length() : (level - 1) * 2);
        return substring + " ";
    }
}

