/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.DeepLClientOptions;
import com.deepl.api.DeepLException;
import com.deepl.api.GlossaryEntries;
import com.deepl.api.LanguageCode;
import com.deepl.api.MultilingualGlossaryDictionaryEntries;
import com.deepl.api.MultilingualGlossaryDictionaryInfo;
import com.deepl.api.MultilingualGlossaryInfo;
import com.deepl.api.TextRephraseOptions;
import com.deepl.api.Translator;
import com.deepl.api.TranslatorOptions;
import com.deepl.api.WriteResult;
import com.deepl.api.http.HttpResponse;
import com.deepl.api.utils.KeyValuePair;
import com.deepl.api.utils.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DeepLClient
extends Translator {
    public DeepLClient(String authKey) throws IllegalArgumentException {
        this(authKey, new DeepLClientOptions());
    }

    @Deprecated
    public DeepLClient(String authKey, TranslatorOptions options) throws IllegalArgumentException {
        super(authKey, options);
    }

    public DeepLClient(String authKey, DeepLClientOptions options) throws IllegalArgumentException {
        super(authKey, options);
    }

    public WriteResult rephraseText(String text, @Nullable String targetLang, @Nullable TextRephraseOptions options) throws InterruptedException, DeepLException {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(text);
        return this.rephraseText(texts, targetLang, options).get(0);
    }

    public List<WriteResult> rephraseText(List<String> texts, @Nullable String targetLang, @Nullable TextRephraseOptions options) throws InterruptedException, DeepLException {
        ArrayList<KeyValuePair<String, String>> params = DeepLClient.createWriteHttpParams(texts, targetLang, options);
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff(String.format("/%s/write/rephrase", new Object[]{this.apiVersion}), params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseWriteResult(response.getBody());
    }

    public MultilingualGlossaryInfo createMultilingualGlossary(String name, List<MultilingualGlossaryDictionaryEntries> glossaryDicts) throws DeepLException, IllegalArgumentException, InterruptedException {
        this.validateParameter("name", name);
        if (glossaryDicts.isEmpty()) {
            throw new IllegalArgumentException("Parameter dictionaries must not be empty");
        }
        ArrayList<KeyValuePair<String, String>> bodyParams = DeepLClient.createGlossaryHttpParams(name, glossaryDicts);
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v3/glossaries", bodyParams);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseMultilingualGlossaryInfo(response.getBody());
    }

    public MultilingualGlossaryInfo createMultilingualGlossaryFromCsv(String name, String sourceLanguageCode, String targetLanguageCode, String csvFile) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.createGlossaryFromCsvInternal(name, sourceLanguageCode, targetLanguageCode, csvFile);
    }

    public MultilingualGlossaryInfo createMultilingualGlossaryFromCsv(String name, String sourceLanguageCode, String targetLanguageCode, File csvFile) throws DeepLException, IllegalArgumentException, InterruptedException, IOException {
        try (FileInputStream stream = new FileInputStream(csvFile);){
            String csvContent = StreamUtil.readStream(stream);
            MultilingualGlossaryInfo multilingualGlossaryInfo = this.createGlossaryFromCsvInternal(name, sourceLanguageCode, targetLanguageCode, csvContent);
            return multilingualGlossaryInfo;
        }
    }

    public MultilingualGlossaryInfo getMultilingualGlossary(String glossaryId) throws DeepLException, InterruptedException {
        String relativeUrl = String.format("/v3/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseMultilingualGlossaryInfo(response.getBody());
    }

    public List<MultilingualGlossaryInfo> listMultilingualGlossaries() throws DeepLException, InterruptedException {
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff("/v3/glossaries");
        this.checkResponse(response, false, false);
        return this.jsonParser.parseMultilingualGlossaryInfoList(response.getBody());
    }

    public MultilingualGlossaryDictionaryEntries getMultilingualGlossaryDictionaryEntries(String glossaryId, String sourceLanguageCode, String targetLanguageCode) throws DeepLException, IllegalArgumentException, InterruptedException {
        this.validateParameter("glossaryId", glossaryId);
        String queryString = this.createLanguageQueryParams(sourceLanguageCode, targetLanguageCode);
        String relativeUrl = String.format("/v3/glossaries/%s/entries%s", glossaryId, queryString);
        HttpResponse response = this.httpClientWrapper.sendGetRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseMultilingualGlossaryDictionaryListResponse(response.getBody()).getDictionaries().get(0).getDictionaryEntries();
    }

    public MultilingualGlossaryDictionaryEntries getMultilingualGlossaryDictionaryEntries(String glossaryId, MultilingualGlossaryDictionaryInfo glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.getMultilingualGlossaryDictionaryEntries(glossaryId, glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode());
    }

    public MultilingualGlossaryDictionaryEntries getMultilingualGlossaryDictionaryEntries(MultilingualGlossaryInfo glossary, String sourceLanguageCode, String targetLanguageCode) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.getMultilingualGlossaryDictionaryEntries(glossary.getGlossaryId(), sourceLanguageCode, targetLanguageCode);
    }

    public MultilingualGlossaryDictionaryEntries getMultilingualGlossaryDictionaryEntries(MultilingualGlossaryInfo glossary, MultilingualGlossaryDictionaryInfo glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.getMultilingualGlossaryDictionaryEntries(glossary.getGlossaryId(), glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode());
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionary(String glossaryId, String sourceLanguageCode, String targetLanguageCode, GlossaryEntries entries) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.replaceGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, entries.toTsv(), "tsv");
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionary(String glossaryId, MultilingualGlossaryDictionaryEntries glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.replaceGlossaryDictionaryInternal(glossaryId, glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode(), glossaryDict.getEntries().toTsv(), "tsv");
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, MultilingualGlossaryDictionaryEntries glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.replaceGlossaryDictionaryInternal(glossary.getGlossaryId(), glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode(), glossaryDict.getEntries().toTsv(), "tsv");
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, String sourceLanguageCode, String targetLanguageCode, GlossaryEntries entries) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.replaceGlossaryDictionaryInternal(glossary.getGlossaryId(), sourceLanguageCode, targetLanguageCode, entries.toTsv(), "tsv");
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionaryFromCsv(String glossaryId, String sourceLanguageCode, String targetLanguageCode, File csvFile) throws DeepLException, IllegalArgumentException, InterruptedException, IOException {
        try (FileInputStream stream = new FileInputStream(csvFile);){
            String csvContent = StreamUtil.readStream(stream);
            MultilingualGlossaryDictionaryInfo multilingualGlossaryDictionaryInfo = this.replaceGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, csvContent, "csv");
            return multilingualGlossaryDictionaryInfo;
        }
    }

    public MultilingualGlossaryDictionaryInfo replaceMultilingualGlossaryDictionaryFromCsv(String glossaryId, String sourceLanguageCode, String targetLanguageCode, String csvContent) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.replaceGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, csvContent, "csv");
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionary(String glossaryId, String sourceLanguageCode, String targetLanguageCode, GlossaryEntries entries) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.updateGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, entries.toTsv(), "tsv");
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, String sourceLanguageCode, String targetLanguageCode, GlossaryEntries entries) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.updateGlossaryDictionaryInternal(glossary.getGlossaryId(), sourceLanguageCode, targetLanguageCode, entries.toTsv(), "tsv");
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionary(String glossaryId, MultilingualGlossaryDictionaryEntries glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.updateGlossaryDictionaryInternal(glossaryId, glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode(), glossaryDict.getEntries().toTsv(), "tsv");
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, MultilingualGlossaryDictionaryEntries glossaryDict) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.updateGlossaryDictionaryInternal(glossary.getGlossaryId(), glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode(), glossaryDict.getEntries().toTsv(), "tsv");
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryName(String glossaryId, String name) throws DeepLException, IllegalArgumentException {
        ArrayList<KeyValuePair<String, String>> bodyParams = new ArrayList<KeyValuePair<String, String>>();
        bodyParams.add(new KeyValuePair<String, String>("name", name));
        String relativeUrl = String.format("/v3/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendPatchRequestWithBackoff(relativeUrl, bodyParams);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseMultilingualGlossaryInfo(response.getBody());
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionaryFromCsv(String glossaryId, String sourceLanguageCode, String targetLanguageCode, File csvFile) throws DeepLException, IllegalArgumentException, InterruptedException, IOException {
        try (FileInputStream stream = new FileInputStream(csvFile);){
            String csvContent = StreamUtil.readStream(stream);
            MultilingualGlossaryInfo multilingualGlossaryInfo = this.updateGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, csvContent, "csv");
            return multilingualGlossaryInfo;
        }
    }

    public MultilingualGlossaryInfo updateMultilingualGlossaryDictionaryFromCsv(String glossaryId, String sourceLanguageCode, String targetLanguageCode, String csvContent) throws DeepLException, IllegalArgumentException, InterruptedException {
        return this.updateGlossaryDictionaryInternal(glossaryId, sourceLanguageCode, targetLanguageCode, csvContent, "csv");
    }

    public void deleteMultilingualGlossary(String glossaryId) throws DeepLException, InterruptedException {
        String relativeUrl = String.format("/v3/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendDeleteRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
    }

    public void deleteMultilingualGlossary(MultilingualGlossaryInfo glossary) throws DeepLException, InterruptedException {
        this.deleteMultilingualGlossary(glossary.getGlossaryId());
    }

    public void deleteMultilingualGlossaryDictionary(String glossaryId, String sourceLanguageCode, String targetLanguageCode) throws DeepLException, InterruptedException, IllegalArgumentException {
        String queryString = this.createLanguageQueryParams(sourceLanguageCode, targetLanguageCode);
        String relativeUrl = String.format("/v3/glossaries/%s/dictionaries%s", glossaryId, queryString);
        HttpResponse response = this.httpClientWrapper.sendDeleteRequestWithBackoff(relativeUrl);
        this.checkResponse(response, false, true);
    }

    public void deleteMultilingualGlossaryDictionary(String glossaryId, MultilingualGlossaryDictionaryInfo glossaryDict) throws DeepLException, InterruptedException, IllegalArgumentException {
        this.deleteMultilingualGlossaryDictionary(glossaryId, glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode());
    }

    public void deleteMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, String sourceLanguageCode, String targetLanguageCode) throws DeepLException, InterruptedException, IllegalArgumentException {
        this.deleteMultilingualGlossaryDictionary(glossary.getGlossaryId(), sourceLanguageCode, targetLanguageCode);
    }

    public void deleteMultilingualGlossaryDictionary(MultilingualGlossaryInfo glossary, MultilingualGlossaryDictionaryInfo glossaryDict) throws DeepLException, InterruptedException, IllegalArgumentException {
        this.deleteMultilingualGlossaryDictionary(glossary.getGlossaryId(), glossaryDict.getSourceLanguageCode(), glossaryDict.getTargetLanguageCode());
    }

    private MultilingualGlossaryInfo createGlossaryFromCsvInternal(String name, String sourceLanguageCode, String targetLanguageCode, String entries) throws DeepLException, InterruptedException {
        ArrayList<KeyValuePair<String, String>> params = DeepLClient.createGlossaryDictionariesHttpParams(sourceLanguageCode, targetLanguageCode, entries, "csv");
        params.add(new KeyValuePair<String, String>("name", name));
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v3/glossaries", params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseMultilingualGlossaryInfo(response.getBody());
    }

    private MultilingualGlossaryDictionaryInfo replaceGlossaryDictionaryInternal(String glossaryId, String sourceLanguageCode, String targetLanguageCode, String entries, String entriesFormat) throws DeepLException, IllegalArgumentException, InterruptedException {
        this.validateParameter("glossaryId", glossaryId);
        this.validateParameter("sourceLanguageCode", sourceLanguageCode);
        this.validateParameter("targetLanguageCode", targetLanguageCode);
        this.validateParameter("entries", entries);
        ArrayList<KeyValuePair<String, String>> bodyParams = new ArrayList<KeyValuePair<String, String>>();
        bodyParams.add(new KeyValuePair<String, String>("source_lang", sourceLanguageCode));
        bodyParams.add(new KeyValuePair<String, String>("target_lang", targetLanguageCode));
        bodyParams.add(new KeyValuePair<String, String>("entries", entries));
        bodyParams.add(new KeyValuePair<String, String>("entries_format", entriesFormat));
        String relativeUrl = String.format("/v3/glossaries/%s/dictionaries", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendPutRequestWithBackoff(relativeUrl, bodyParams);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseMultilingualGlossaryDictionaryInfo(response.getBody());
    }

    private MultilingualGlossaryInfo updateGlossaryDictionaryInternal(String glossaryId, String sourceLanguageCode, String targetLanguageCode, String entries, String entriesFormat) throws DeepLException, IllegalArgumentException, InterruptedException {
        this.validateParameter("glossaryId", glossaryId);
        this.validateParameter("sourceLanguageCode", sourceLanguageCode);
        this.validateParameter("targetLanguageCode", targetLanguageCode);
        this.validateParameter("entries", entries);
        ArrayList<KeyValuePair<String, String>> bodyParams = DeepLClient.createGlossaryDictionariesHttpParams(sourceLanguageCode, targetLanguageCode, entries, entriesFormat);
        String relativeUrl = String.format("/v3/glossaries/%s", glossaryId);
        HttpResponse response = this.httpClientWrapper.sendPatchRequestWithBackoff(relativeUrl, bodyParams);
        this.checkResponse(response, false, true);
        return this.jsonParser.parseMultilingualGlossaryInfo(response.getBody());
    }

    private String createLanguageQueryParams(String sourceLanguageCode, String targetLanguageCode) throws IllegalArgumentException, DeepLException {
        this.validateParameter("sourceLanguageCode", sourceLanguageCode);
        this.validateParameter("targetLanguageCode", targetLanguageCode);
        try {
            return "?" + String.join((CharSequence)"&", String.format("source_lang=%s", URLEncoder.encode(sourceLanguageCode, StandardCharsets.UTF_8.name())), String.format("target_lang=%s", URLEncoder.encode(targetLanguageCode, StandardCharsets.UTF_8.name())));
        }
        catch (UnsupportedEncodingException exception) {
            throw new DeepLException("Error while URL-encoding request", exception);
        }
    }

    private void validateParameter(String paramName, String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter %s must not be empty", paramName));
        }
    }

    protected static ArrayList<KeyValuePair<String, String>> createWriteHttpParams(List<String> texts, @Nullable String targetLang, @Nullable TextRephraseOptions options) {
        targetLang = LanguageCode.standardize(targetLang);
        DeepLClient.checkValidLanguages(null, targetLang);
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        if (targetLang != null) {
            params.add(new KeyValuePair<String, String>("target_lang", targetLang));
        }
        if (options != null && options.getWritingStyle() != null) {
            params.add(new KeyValuePair<String, String>("writing_style", options.getWritingStyle()));
        }
        if (options != null && options.getTone() != null) {
            params.add(new KeyValuePair<String, String>("tone", options.getTone()));
        }
        texts.forEach(text -> {
            if (text.isEmpty()) {
                throw new IllegalArgumentException("text must not be empty");
            }
            params.add(new KeyValuePair<String, String>("text", (String)text));
        });
        return params;
    }

    protected static ArrayList<KeyValuePair<String, String>> createGlossaryHttpParams(String name, List<MultilingualGlossaryDictionaryEntries> glossaryDicts) {
        ArrayList<KeyValuePair<String, String>> bodyParams = new ArrayList<KeyValuePair<String, String>>();
        bodyParams.add(new KeyValuePair<String, String>("name", name));
        for (int i = 0; i < glossaryDicts.size(); ++i) {
            bodyParams.add(new KeyValuePair<String, String>(String.format("dictionaries[%d].source_lang", i), glossaryDicts.get(i).getSourceLanguageCode()));
            bodyParams.add(new KeyValuePair<String, String>(String.format("dictionaries[%d].target_lang", i), glossaryDicts.get(i).getTargetLanguageCode()));
            bodyParams.add(new KeyValuePair<String, String>(String.format("dictionaries[%d].entries", i), glossaryDicts.get(i).getEntries().toTsv()));
            bodyParams.add(new KeyValuePair<String, String>(String.format("dictionaries[%d].entries_format", i), "tsv"));
        }
        return bodyParams;
    }

    protected static ArrayList<KeyValuePair<String, String>> createGlossaryDictionariesHttpParams(String sourceLanguageCode, String targetLanguageCode, String entries, String entriesFormat) {
        ArrayList<KeyValuePair<String, String>> bodyParams = new ArrayList<KeyValuePair<String, String>>();
        bodyParams.add(new KeyValuePair<String, String>("dictionaries[0].source_lang", sourceLanguageCode));
        bodyParams.add(new KeyValuePair<String, String>("dictionaries[0].target_lang", targetLanguageCode));
        bodyParams.add(new KeyValuePair<String, String>("dictionaries[0].entries", entries));
        bodyParams.add(new KeyValuePair<String, String>("dictionaries[0].entries_format", entriesFormat));
        return bodyParams;
    }
}

