/*
 * Decompiled with CFR 0.152.
 */
package com.dcsquare.dropwizard.papertrail;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.papertrailapp.logback.Syslog4jAppender;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.validation.PortRange;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.impl.net.tcp.ssl.SSLTCPNetSyslogConfig;

@JsonTypeName(value="papertrail")
public class PapertrailAppenderFactory
extends AbstractAppenderFactory {
    @JsonProperty
    @NotEmpty
    private String ident;
    @JsonProperty
    @NotEmpty
    private String host;
    @JsonProperty
    @PortRange(min=1)
    @NotNull
    private Integer port;
    @JsonProperty
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @JsonProperty
    @NotEmpty
    private String facility = "USER";
    @JsonProperty
    private boolean sendLocalName = true;

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    public void setSendLocalName(boolean sendLocalName) {
        this.sendLocalName = sendLocalName;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, Layout<ILoggingEvent> layout) {
        Syslog4jAppender syslogAppender = new Syslog4jAppender();
        syslogAppender.setContext((Context)context);
        syslogAppender.setLayout(layout == null ? this.buildLayout(context, this.timeZone) : layout);
        syslogAppender.setName("SYSLOG-TLS");
        SSLTCPNetSyslogConfig syslogConfig = new SSLTCPNetSyslogConfig();
        syslogConfig.setIdent(this.ident);
        syslogConfig.setHost(this.host);
        syslogConfig.setPort(this.port.intValue());
        syslogConfig.setFacility(this.facility);
        syslogConfig.setSendLocalName(this.sendLocalName);
        syslogAppender.setSyslogConfig((SyslogConfigIF)syslogConfig);
        this.addThresholdFilter((FilterAttachable)syslogAppender, this.threshold);
        syslogAppender.start();
        return syslogAppender;
    }
}

