/***************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.maven.mgr;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.commons.json.JSONObject;

/**
 * Replicates a content package defined on a remote CRX or Communique 5 system.
 */
@Mojo(name = "replicate", requiresProject = false)
public class PackageReplicateMojo extends AbstractPackageManagerMojo {
    
    /**
     * The path of the package to build on the target system.
     */
    @Parameter(property = "vault.path", required = true)
    private String path;
    
    /**
     * If true, fail the build if there is an error while building.
     */
    @Parameter(property = "vault.failOnError", defaultValue="true")
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        JSONObject result = postRequest(Command.REPLICATE, path);

        if (checkStatus(result)) {
            getLog().info("Package " + path + " replicated on " + getTargetURL(path, Command.REPLICATE));
        } else if (failOnError) {
            throw new MojoFailureException("Error while replicating package. Check log for details.");
        }
    }

}
