/***************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.maven.mgr;

import org.apache.maven.plugins.annotations.Mojo;

/**
 * Removes a content package installed on a remote CRX or Communique 5 system.
 */
@Mojo(name = "rm", requiresProject = false)
public class PackageRemoveMojo extends AbstractNameOrPathPackageManagerMojo {

    @Override
    protected String getLegacyCommandName() {
        return "rm";
    }

    @Override
    protected Command getCommand() {
        return Command.REMOVE;
    }

    @Override
    protected String getInfoMessageFormat() {
        return "Package %s removed from %s.";
    }

    @Override
    protected String getErrorMessage() {
        return "Error while removing package. Check log for details.";
    }

}
