/***************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.maven.mgr;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Lists packages installed on remote CRX or Communique 5 system.
 */
@Mojo(name = "ls", requiresProject = false)
public class PackageListMojo extends AbstractPackageManagerMojo {
    
    /**
     * If true, fail the build if there is an error getting the package list.
     */
    @Parameter(property = "vault.failOnError", defaultValue="false")
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Xpp3Dom result = postRequest("ls", null);
        if (checkStatus(result)) {
            Xpp3Dom packages = getNestedChild(result, "response/data/packages");
            if (packages == null) {
                getLog().info("No packages installed");
            } else {
                getLog().info("Packages installed at " + getTargetURL());
                Xpp3Dom packageList[] = packages.getChildren("package");
                for (Xpp3Dom aPackageList : packageList) {
                    logPackage(aPackageList);
                }
            }
        } else if (failOnError) {
            throw new MojoFailureException("Error getting package list. Check log for details.");
        }
    }

}
