/***************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.maven.mgr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;

/**
 * Downloads a content package defined on a remote CRX or Communique 5 system.
 */
@Mojo(name = "download", requiresProject = false)
public class PackageDownloadMojo extends AbstractPackageManagerMojo {

    /**
     * The path of the package on the target system.
     */
    @Parameter(property = "vault.path", required = true)
    private String path;

    /**
     * If true, fail the build if there is an error while building.
     */
    @Parameter(property = "vault.failOnError", defaultValue = "true")
    private boolean failOnError;

    /**
     * The output file to save.
     */
    @Parameter(property = "vault.outputFile", required = true)
    private String outputFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();

        final String url = getDownloadURL();
        getLog().info("GETting from " + url);

        final GetMethod get = new GetMethod(url);
        OutputStream outstream = null;
        InputStream instream = null;

        try {
            final HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            final UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(getUserId(),
                    getPassword());
            client.getState().setCredentials(AuthScope.ANY, credentials);

            setupProxy(client);

            client.getHttpConnectionManager().getParams().setConnectionTimeout(getTimoutMs());
            final int status = client.executeMethod(get);
            if (status == 200) {
                final File output = new File(outputFile);
                outstream = new FileOutputStream(output);
                instream = get.getResponseBodyAsStream();
                IOUtil.copy(instream, outstream);
            } else if (failOnError) {
                throw new MojoFailureException("Unable to download file. Status code = " + status);
            }
        } catch (Exception e) {
            throw new MojoExecutionException("Unable to download.", e);
        } finally {
            IOUtil.close(instream);
            IOUtil.close(outstream);
            get.releaseConnection();
        }
    }

    private String getDownloadURL() {
        StringBuilder builder = new StringBuilder();
        builder.append(getTargetURL().replace("service", "download"));
        builder.append("?_charset_=utf-8&");
        builder.append("path=");
        builder.append(path);
        return builder.toString();
    }
}
