/***************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.maven.mgr;

import org.apache.maven.plugins.annotations.Mojo;

/**
 * Builds a content package defined on a remote CRX or Communique 5 system.
 */
@Mojo(name = "build")
public class PackageBuildMojo extends AbstractNameOrPathPackageManagerMojo {

    @Override
    protected String getLegacyCommandName() {
        return "build";
    }

    @Override
    protected Command getCommand() {
        return Command.BUILD;
    }

    @Override
    protected String getInfoMessageFormat() {
        return "Package %s built on %s.";
    }

    @Override
    protected String getErrorMessage() {
        return "Error while building package. Check log for details.";
    }

}
