/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="download", requiresProject=false)
public class PackageDownloadMojo
extends AbstractPackageManagerMojo {
    @Parameter(property="vault.path", required=true)
    private String path;
    @Parameter(property="vault.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="vault.outputFile", required=true)
    private String outputFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        String url = this.getDownloadURL();
        this.getLog().info((CharSequence)("GETting from " + url));
        GetMethod get = new GetMethod(url);
        FileOutputStream outstream = null;
        InputStream instream = null;
        try {
            HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUserId(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.setupProxy(client);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimoutMs());
            int status = client.executeMethod((HttpMethod)get);
            if (status == 200) {
                File output = new File(this.outputFile);
                outstream = new FileOutputStream(output);
                instream = get.getResponseBodyAsStream();
                IOUtil.copy((InputStream)instream, (OutputStream)outstream);
            } else if (this.failOnError) {
                throw new MojoFailureException("Unable to download file. Status code = " + status);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to download.", e);
        }
        finally {
            IOUtil.close(instream);
            IOUtil.close(outstream);
            get.releaseConnection();
        }
    }

    private String getDownloadURL() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTargetURL().replace("service", "download"));
        builder.append("?_charset_=utf-8&");
        builder.append("path=");
        builder.append(this.path);
        return builder.toString();
    }
}

