/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack;

import com.day.jcr.vault.maven.pack.impl.StringFilterSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedded {
    private final StringFilterSet groupId = new StringFilterSet();
    private final StringFilterSet artifactId = new StringFilterSet();
    private ScopeArtifactFilter scope;
    private String type;
    private String classifier;
    private boolean filter;
    private String target;
    private String destFileName;
    private boolean excludeTransitive;

    public void setGroupId(String groupId) {
        this.groupId.addEntries(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId.addEntries(artifactId);
    }

    public void setScope(String scope) {
        this.scope = new ScopeArtifactFilter(scope);
    }

    public void setAddFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    public void setTarget(String target) {
        if (!target.endsWith("/")) {
            target = target + "/";
        }
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public List<Artifact> getMatchingArtifacts(MavenProject project) {
        Set deps = this.excludeTransitive ? project.getDependencyArtifacts() : project.getArtifacts();
        ArrayList<Artifact> matches = new ArrayList<Artifact>();
        for (Object dep : deps) {
            Artifact artifact = (Artifact)dep;
            if (!this.groupId.contains(artifact.getGroupId()) || !this.artifactId.contains(artifact.getArtifactId()) || this.scope != null && !this.scope.include(artifact) || this.type != null && !this.type.equals(artifact.getType()) || this.classifier != null && !this.classifier.equals(artifact.getClassifier())) continue;
            matches.add(artifact);
        }
        return matches;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Embedded: ");
        if (this.groupId != null) {
            builder.append("groupId=").append(this.groupId).append(",");
        }
        if (this.artifactId != null) {
            builder.append("artifactId=").append(this.artifactId).append(",");
        }
        if (this.scope != null) {
            builder.append("scope=").append(this.scope).append(",");
        }
        builder.append("filter=").append(this.filter);
        builder.append(",excludeTransitive=").append(this.excludeTransitive);
        if (this.target != null) {
            builder.append(",target=").append(this.target);
        }
        if (this.destFileName != null) {
            builder.append(",destFileName=").append(this.destFileName);
        }
        return builder.toString();
    }
}

