/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import java.util.Collection;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PackageListMojo
extends AbstractPackageManagerMojo {
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Xpp3Dom result = this.postRequest("ls", (Collection<Part>)null);
        if (this.checkStatus(result)) {
            Xpp3Dom packages = this.getNestedChild(result, "response/data/packages");
            if (packages == null) {
                this.getLog().info((CharSequence)"No packages installed");
            } else {
                this.getLog().info((CharSequence)("Packages installed at " + this.getTargetURL()));
                Xpp3Dom[] packageList = packages.getChildren("package");
                for (int i = 0; i < packageList.length; ++i) {
                    this.logPackage(packageList[i]);
                }
            }
        } else if (this.failOnError) {
            throw new MojoFailureException("Error getting package list. Check log for details.");
        }
    }
}

