/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PackageInstallMojo
extends AbstractPackageManagerMojo {
    private MavenProject project;
    private File packageFile;
    private String name;
    private boolean install;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "zip";
    private String artifact;
    private List pomRemoteRepositories;
    private String repositoryId = "temp";
    private String repositoryUrl;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactRepositoryLayout repositoryLayout;
    private ArtifactMetadataSource source;
    private ArtifactRepository localRepository;
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        File file = null;
        if (this.artifact != null || this.artifactId != null && this.groupId != null && this.version != null) {
            file = this.resolvePackageFileFromArtifact();
        }
        if (file == null) {
            file = this.getProjectArtifactFile();
        }
        if (file != null) {
            this.packageFile = file;
        }
        if (this.packageFile == null) {
            throw new MojoExecutionException("Missing artifact to install.");
        }
        if (!this.packageFile.canRead()) {
            throw new MojoExecutionException("Cannot access package file " + this.packageFile);
        }
        this.uploadPackage();
    }

    protected File getProjectArtifactFile() {
        return this.project.getArtifact().getFile();
    }

    private File resolvePackageFileFromArtifact() throws MojoFailureException, MojoExecutionException {
        if (this.artifactId == null && this.artifact == null) {
            return null;
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length != 3 && tokens.length != 4) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length == 4) {
                this.packaging = tokens[3];
            }
        }
        Artifact packageArtifact = this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging);
        if (this.pomRemoteRepositories == null) {
            this.pomRemoteRepositories = new ArrayList();
        }
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>(this.pomRemoteRepositories);
        if (this.repositoryUrl != null) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.repositoryLayout, policy, policy);
            repoList.add(remoteRepo);
        }
        try {
            this.artifactResolver.resolve(packageArtifact, repoList, this.localRepository);
            this.getLog().info((CharSequence)("Resolved artifact to " + packageArtifact.getFile().getAbsolutePath()));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        return packageArtifact.getFile();
    }

    private void uploadPackage() throws MojoExecutionException, MojoFailureException {
        String task = this.install ? "Installing" : "Uploading";
        this.getLog().info((CharSequence)(task + " " + this.name + " (" + this.packageFile + ") to " + this.getTargetURL()));
        try {
            Xpp3Dom result;
            ArrayList<Part> parts = new ArrayList<Part>();
            parts.add((Part)new FilePart("file", this.packageFile));
            if (this.install) {
                parts.add((Part)new StringPart("install", "true"));
            }
            if (this.checkStatus(result = this.postRequest(null, parts))) {
                Xpp3Dom log;
                Xpp3Dom pkg = this.getNestedChild(result, "response/data/package");
                this.logPackage(pkg);
                if (this.isVerbose() && (log = this.getNestedChild(result, "response/data/log")) != null) {
                    this.getLog().info((CharSequence)this.getText(log, null));
                }
            } else if (this.failOnError) {
                throw new MojoFailureException("Error while installing package. Check log for details.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

