/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFsPersistenceManager
extends AbstractBundlePersistenceManager {
    private static Logger log = LoggerFactory.getLogger(BundleFsPersistenceManager.class);
    protected boolean initialized;
    protected CloseableBLOBStore blobStore;
    private int blobFSBlockSize;
    private int minBlobSize = 4096;
    private FileSystem itemFs;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    private String name = super.toString();

    public String getBlobFSBlockSize() {
        return String.valueOf(this.blobFSBlockSize);
    }

    public void setBlobFSBlockSize(String size) {
        this.blobFSBlockSize = Integer.decode(size);
    }

    public boolean useLocalFsBlobStore() {
        return this.blobFSBlockSize == 0;
    }

    public String getMinBlobSize() {
        return String.valueOf(this.minBlobSize);
    }

    public void setMinBlobSize(String minBlobSize) {
        this.minBlobSize = Integer.decode(minBlobSize);
    }

    public void setErrorHandling(String errorHandling) {
        this.errorHandling = new ErrorHandling(errorHandling);
    }

    public String getErrorHandling() {
        return this.errorHandling.toString();
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(context);
        this.name = context.getHomeDir().getName();
        this.itemFs = new BasedFileSystem(context.getFileSystem(), "items");
        if (this.useLocalFsBlobStore()) {
            LocalFileSystem blobFS = new LocalFileSystem();
            blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
            blobFS.init();
            this.blobStore = new FSBlobStore((FileSystem)blobFS);
        } else {
            this.blobStore = new FSBlobStore(this.itemFs);
        }
        this.binding = new BundleBinding(this.errorHandling, (BLOBStore)this.blobStore, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize((long)this.minBlobSize);
        this.initialized = true;
    }

    @Override
    protected BLOBStore getBlobStore() {
        return this.blobStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.blobStore.close();
            this.blobStore = null;
            this.itemFs.close();
            this.itemFs = null;
            super.close();
        }
        finally {
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        NodePropBundle nodePropBundle;
        String path = this.buildNodeFilePath(null, id).toString();
        if (!this.itemFs.exists(path)) {
            return null;
        }
        InputStream in = this.itemFs.getInputStream(path);
        try {
            nodePropBundle = this.binding.readBundle(in, id);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            catch (Exception e) {
                String msg = "failed to read bundle: " + id + ": " + e;
                log.error(msg);
                throw new ItemStateException(msg, (Throwable)e);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return nodePropBundle;
    }

    @Override
    protected StringBuffer buildNodeFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append('.');
        buf.append("n");
        return buf;
    }

    @Override
    protected StringBuffer buildNodeReferencesFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append('.');
        buf.append("r");
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            StringBuffer buf = this.buildNodeFolderPath(null, bundle.getId());
            buf.append('.');
            buf.append("n");
            String fileName = buf.toString();
            String dir = fileName.substring(0, fileName.lastIndexOf(47));
            if (!this.itemFs.exists(dir)) {
                this.itemFs.createFolder(dir);
            }
            OutputStream out = this.itemFs.getOutputStream(fileName);
            try {
                this.binding.writeBundle(out, bundle);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to write bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    @Override
    protected synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            StringBuffer buf = this.buildNodeFilePath(null, bundle.getId());
            this.itemFs.deleteFile(buf.toString());
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)((Object)e);
            }
            String msg = "failed to delete bundle: " + bundle.getId();
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized NodeReferences loadReferencesTo(NodeId targetId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InputStream in = null;
        try {
            String path = this.buildNodeReferencesFilePath(null, targetId).toString();
            if (!this.itemFs.exists(path)) {
                throw new NoSuchItemStateException(targetId.toString());
            }
            in = this.itemFs.getInputStream(path);
            NodeReferences refs = new NodeReferences(targetId);
            Serializer.deserialize((NodeReferences)refs, (InputStream)in);
            nodeReferences = refs;
        }
        catch (NoSuchItemStateException e) {
            try {
                throw e;
                catch (Exception e2) {
                    String msg = "failed to read references: " + targetId;
                    log.error(msg, (Throwable)e2);
                    throw new ItemStateException(msg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return nodeReferences;
    }

    @Override
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            StringBuffer buf = this.buildNodeFolderPath(null, refs.getTargetId());
            buf.append('.');
            buf.append("r");
            String fileName = buf.toString();
            String dir = fileName.substring(0, fileName.lastIndexOf(47));
            if (!this.itemFs.exists(dir)) {
                this.itemFs.createFolder(dir);
            }
            OutputStream out = this.itemFs.getOutputStream(fileName);
            Serializer.serialize((NodeReferences)refs, (OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            String msg = "failed to write " + refs;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    @Override
    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            StringBuffer buf = this.buildNodeReferencesFilePath(null, refs.getTargetId());
            this.itemFs.deleteFile(buf.toString());
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)((Object)e);
            }
            String msg = "failed to delete " + refs;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    public synchronized boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            StringBuffer buf = this.buildNodeReferencesFilePath(null, targetId);
            return this.itemFs.exists(buf.toString());
        }
        catch (Exception e) {
            String msg = "failed to check existence of node references: " + targetId;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected void logException(String message, SQLException se) {
        if (message != null) {
            log.error(message);
        }
        log.error("       Reason: " + se.getMessage());
        log.error("   State/Code: " + se.getSQLState() + "/" + se.getErrorCode());
        log.debug("   dump:", (Throwable)se);
    }

    public String toString() {
        return this.name;
    }

    public List<NodeId> getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException {
        ArrayList<NodeId> list = new ArrayList<NodeId>();
        try {
            this.getListRecursive(list, "", bigger == null ? null : bigger, maxCount);
            return list;
        }
        catch (FileSystemException e) {
            String msg = "failed to read node list: " + bigger + ": " + (Object)((Object)e);
            log.error(msg);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected NodeId getIdFromFileName(String fileName) {
        char c;
        StringBuffer buff = new StringBuffer(35);
        if (!fileName.endsWith(".n")) {
            return null;
        }
        for (int i = 0; i < fileName.length() && (c = fileName.charAt(i)) != '.'; ++i) {
            if (c == '/') continue;
            buff.append(c);
            int len = buff.length();
            if (len != 8 && len != 13 && len != 18 && len != 23) continue;
            buff.append('-');
        }
        return new NodeId(buff.toString());
    }

    private void getListRecursive(ArrayList<NodeId> list, String path, NodeId bigger, int maxCount) throws FileSystemException {
        if (maxCount > 0 && list.size() >= maxCount) {
            return;
        }
        Object[] files = this.itemFs.listFiles(path);
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            Object f = files[i];
            NodeId n = this.getIdFromFileName(path + "/" + (String)f);
            if (n == null || bigger != null && bigger.toString().compareTo(n.toString()) >= 0) continue;
            list.add(n);
            if (maxCount <= 0 || list.size() < maxCount) continue;
            return;
        }
        Object[] dirs = this.itemFs.listFolders(path);
        Arrays.sort(dirs);
        for (int i = 0; i < dirs.length; ++i) {
            this.getListRecursive(list, path + "/" + (String)dirs[i], bigger, maxCount);
        }
    }

    private class FSBlobStore
    extends FileSystemBLOBStore
    implements CloseableBLOBStore {
        private FileSystem fs;

        public FSBlobStore(FileSystem fs) {
            super(fs);
            this.fs = fs;
        }

        public String createId(PropertyId id, int index) {
            return BundleFsPersistenceManager.this.buildBlobFilePath(null, id, index).toString();
        }

        @Override
        public void close() {
            try {
                this.fs.close();
                this.fs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

