/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;

public class AbstractBundlePersistenceManager_friend {
    private AbstractBundlePersistenceManager bundlePM;
    private Method loadAndCheckMethod;

    public AbstractBundlePersistenceManager_friend(AbstractBundlePersistenceManager bundlePM) {
        this.bundlePM = bundlePM;
        try {
            this.loadAndCheckMethod = bundlePM.getClass().getMethod("loadBundle", NodeId.class, Boolean.TYPE);
        }
        catch (SecurityException e) {
            this.loadAndCheckMethod = null;
        }
        catch (NoSuchMethodException e) {
            this.loadAndCheckMethod = null;
        }
    }

    public AbstractBundlePersistenceManager getRealPM() {
        return this.bundlePM;
    }

    public NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        return this.bundlePM.loadBundle(id);
    }

    public NodePropBundle loadBundle(NodeId id, boolean checkBeforeLoading) throws ItemStateException {
        if (this.loadAndCheckMethod != null) {
            try {
                return (NodePropBundle)this.loadAndCheckMethod.invoke((Object)this.bundlePM, id, Boolean.TRUE);
            }
            catch (IllegalArgumentException e) {
                return this.bundlePM.loadBundle(id);
            }
            catch (IllegalAccessException e) {
                return this.bundlePM.loadBundle(id);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof ItemStateException)) {
                    throw new ItemStateException("Could not call loadBundle(id, true) via reflection.", (Throwable)e);
                }
                throw (ItemStateException)e.getCause();
            }
        }
        return this.bundlePM.loadBundle(id);
    }

    public void storeBundle(NodePropBundle bundle) throws ItemStateException {
        this.bundlePM.storeBundle(bundle);
    }

    public void evictBundle(NodeId id) {
        this.bundlePM.evictBundle(id);
    }

    public BLOBStore getBlobStore() {
        return this.bundlePM.getBlobStore();
    }
}

