/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;

public class ZombieHierarchyManager
extends HierarchyManagerImpl {
    protected ItemStateManager attic;

    public ZombieHierarchyManager(HierarchyManagerImpl parent, ItemStateManager provider, ItemStateManager attic) {
        super(parent.getRootNodeId(), provider);
        this.attic = attic;
    }

    @Override
    protected ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.attic.hasItemState(id)) {
            return this.attic.getItemState(id);
        }
        return super.getItemState(id);
    }

    @Override
    protected boolean hasItemState(ItemId id) {
        if (this.attic.hasItemState(id)) {
            return true;
        }
        return super.hasItemState(id);
    }

    @Override
    protected NodeId getParentId(ItemState state) {
        if (state.hasOverlayedState()) {
            return state.getOverlayedState().getParentId();
        }
        return super.getParentId(state);
    }

    @Override
    protected ChildNodeEntry getChildNodeEntry(NodeState parent, Name name, int index) {
        ChildNodeEntry entry = super.getChildNodeEntry(parent, name, index);
        if (entry == null) {
            for (ChildNodeEntry candidate : parent.getRemovedChildNodeEntries()) {
                if (!candidate.getName().equals(name) || candidate.getIndex() != index) continue;
                entry = candidate;
                break;
            }
        }
        return entry;
    }

    @Override
    protected ChildNodeEntry getChildNodeEntry(NodeState parent, NodeId id) {
        ChildNodeEntry entry = super.getChildNodeEntry(parent, id);
        if (entry == null) {
            for (ChildNodeEntry candidate : parent.getRemovedChildNodeEntries()) {
                if (!candidate.getId().equals((Object)id)) continue;
                entry = candidate;
                break;
            }
        }
        return entry;
    }
}

